/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.tools.cli.commands.bookies;

import java.io.IOException;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Map;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.BookieInfoReader;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.tools.cli.helpers.BookieCommand;
import org.apache.bookkeeper.tools.cli.helpers.CommandHelpers;
import org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.bookkeeper.tools.framework.CliSpec;

public class InfoCommand
extends BookieCommand<CliFlags> {
    private static final String NAME = "info";
    private static final String DESC = "Retrieve bookie info such as free and total disk space.";

    public InfoCommand() {
        super(CliSpec.newBuilder().withName(NAME).withFlags(new CliFlags()).withDescription(DESC).build());
    }

    String getReadable(long val) {
        double d;
        String[] unit = new String[]{"", "KB", "MB", "GB", "TB"};
        int cnt = 0;
        for (d = (double)val; d >= 1000.0 && cnt < unit.length - 1; d /= 1000.0, ++cnt) {
        }
        DecimalFormat df = new DecimalFormat("#.###");
        df.setRoundingMode(RoundingMode.DOWN);
        return cnt > 0 ? "(" + df.format(d) + unit[cnt] + ")" : unit[cnt];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean apply(ServerConfiguration conf, CliFlags cmdFlags) {
        ClientConfiguration clientConf = new ClientConfiguration(conf);
        clientConf.setDiskWeightBasedPlacementEnabled(true);
        try (BookKeeper bk = new BookKeeper(clientConf);){
            Map<BookieSocketAddress, BookieInfoReader.BookieInfo> map = bk.getBookieInfo();
            if (map.size() == 0) {
                System.out.println("Failed to retrieve bookie information from any of the bookies");
                bk.close();
                boolean bl2 = true;
                return bl2;
            }
            System.out.println("Free disk space info:");
            long totalFree = 0L;
            long total = 0L;
            for (Map.Entry<BookieSocketAddress, BookieInfoReader.BookieInfo> e : map.entrySet()) {
                BookieInfoReader.BookieInfo bInfo = e.getValue();
                BookieSocketAddress bookieId = e.getKey();
                System.out.println(CommandHelpers.getBookieSocketAddrStringRepresentation(bookieId) + ":\tFree: " + bInfo.getFreeDiskSpace() + this.getReadable(bInfo.getFreeDiskSpace()) + "\tTotal: " + bInfo.getTotalDiskSpace() + this.getReadable(bInfo.getTotalDiskSpace()));
                totalFree += bInfo.getFreeDiskSpace();
                total += bInfo.getTotalDiskSpace();
            }
            System.out.println("Total free disk space in the cluster:\t" + totalFree + this.getReadable(totalFree));
            System.out.println("Total disk capacity in the cluster:\t" + total + this.getReadable(total));
            bk.close();
            boolean bl = true;
            return bl;
        }
        catch (IOException | InterruptedException | BKException e) {
            e.printStackTrace();
            return true;
        }
    }
}

