/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.constraints;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.constraints.DecimalMin;

public class DecimalMinValidatorForNumber
implements ConstraintValidator<DecimalMin, Number> {
    private BigDecimal minValue;

    public void initialize(DecimalMin annotation) {
        try {
            this.minValue = new BigDecimal(annotation.value());
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException(annotation.value() + " does not represent a valid BigDecimal format");
        }
    }

    public boolean isValid(Number value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).compareTo(this.minValue) != -1;
        }
        if (value instanceof BigInteger) {
            return new BigDecimal((BigInteger)value).compareTo(this.minValue) != -1;
        }
        return new BigDecimal(value.doubleValue()).compareTo(this.minValue) != -1;
    }
}

