/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.server;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.concurrent.Callable;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.calcite.avatica.AvaticaUtils;
import org.apache.calcite.avatica.metrics.MetricsSystem;
import org.apache.calcite.avatica.metrics.Timer;
import org.apache.calcite.avatica.metrics.noop.NoopMetricsSystem;
import org.apache.calcite.avatica.remote.Handler;
import org.apache.calcite.avatica.remote.JsonHandler;
import org.apache.calcite.avatica.remote.MetricsHelper;
import org.apache.calcite.avatica.remote.Service;
import org.apache.calcite.avatica.server.AbstractAvaticaHandler;
import org.apache.calcite.avatica.server.AvaticaServerConfiguration;
import org.apache.calcite.avatica.server.RemoteUserDisallowedException;
import org.apache.calcite.avatica.server.RemoteUserExtractionException;
import org.apache.calcite.avatica.util.UnsynchronizedBuffer;
import org.eclipse.jetty.server.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvaticaJsonHandler
extends AbstractAvaticaHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AvaticaJsonHandler.class);
    final Service service;
    final JsonHandler jsonHandler;
    final MetricsSystem metrics;
    final Timer requestTimer;
    final ThreadLocal<UnsynchronizedBuffer> threadLocalBuffer;
    final AvaticaServerConfiguration serverConfig;

    public AvaticaJsonHandler(Service service) {
        this(service, (MetricsSystem)NoopMetricsSystem.getInstance(), null);
    }

    public AvaticaJsonHandler(Service service, MetricsSystem metrics) {
        this(service, metrics, null);
    }

    public AvaticaJsonHandler(Service service, MetricsSystem metrics, AvaticaServerConfiguration serverConfig) {
        this.service = Objects.requireNonNull(service);
        this.metrics = Objects.requireNonNull(metrics);
        this.jsonHandler = new JsonHandler(service, this.metrics);
        this.requestTimer = this.metrics.getTimer(MetricsHelper.concat(AvaticaJsonHandler.class, (String)"Handler.RequestTimings"));
        this.threadLocalBuffer = new ThreadLocal<UnsynchronizedBuffer>(){

            @Override
            public UnsynchronizedBuffer initialValue() {
                return new UnsynchronizedBuffer();
            }
        };
        this.serverConfig = serverConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        block25: {
            try (Timer.Context ctx = this.requestTimer.start();){
                Handler.HandlerResponse<String> jsonResponse;
                if (!this.isUserPermitted(this.serverConfig, baseRequest, request, response)) {
                    LOG.debug("HTTP request from {} is unauthenticated and authentication is required", (Object)request.getRemoteAddr());
                    return;
                }
                response.setContentType("application/json;charset=utf-8");
                response.setStatus(200);
                if (!request.getMethod().equals("POST")) break block25;
                String rawRequest = request.getHeader("request");
                if (rawRequest == null) {
                    UnsynchronizedBuffer buffer = this.threadLocalBuffer.get();
                    try (ServletInputStream inputStream = request.getInputStream();){
                        byte[] bytes = AvaticaUtils.readFullyToBytes((InputStream)inputStream, (UnsynchronizedBuffer)buffer);
                        String encoding = request.getCharacterEncoding();
                        if (encoding == null) {
                            encoding = "UTF-8";
                        }
                        rawRequest = new String(bytes, encoding);
                    }
                    finally {
                        buffer.reset();
                    }
                }
                final String jsonRequest = rawRequest;
                LOG.trace("request: {}", (Object)jsonRequest);
                try {
                    if (null != this.serverConfig && this.serverConfig.supportsImpersonation()) {
                        String remoteUser = this.serverConfig.getRemoteUserExtractor().extract(request);
                        jsonResponse = this.serverConfig.doAsRemoteUser(remoteUser, request.getRemoteAddr(), new Callable<Handler.HandlerResponse<String>>(){

                            @Override
                            public Handler.HandlerResponse<String> call() {
                                return AvaticaJsonHandler.this.jsonHandler.apply(jsonRequest);
                            }
                        });
                    } else {
                        jsonResponse = this.jsonHandler.apply(jsonRequest);
                    }
                }
                catch (RemoteUserExtractionException e) {
                    LOG.debug("Failed to extract remote user from request", (Throwable)e);
                    jsonResponse = this.jsonHandler.unauthenticatedErrorResponse((Exception)e);
                }
                catch (RemoteUserDisallowedException e) {
                    LOG.debug("Remote user is not authorized", (Throwable)e);
                    jsonResponse = this.jsonHandler.unauthorizedErrorResponse((Exception)e);
                }
                catch (Exception e) {
                    LOG.debug("Error invoking request from {}", (Object)baseRequest.getRemoteAddr(), (Object)e);
                    jsonResponse = this.jsonHandler.convertToErrorResponse(e);
                }
                LOG.trace("response: {}", (Object)jsonResponse);
                baseRequest.setHandled(true);
                response.setStatus(jsonResponse.getStatusCode());
                response.getWriter().println((String)jsonResponse.getResponse());
            }
        }
    }

    @Override
    public void setServerRpcMetadata(Service.RpcMetadataResponse metadata) {
        this.service.setRpcMetadata(metadata);
        this.jsonHandler.setRpcMetadata(metadata);
    }

    @Override
    public MetricsSystem getMetrics() {
        return this.metrics;
    }
}

