/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.server;

import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.calcite.avatica.server.RemoteUserExtractionException;
import org.apache.calcite.avatica.server.RemoteUserExtractor;

public class HttpQueryStringParameterRemoteUserExtractor
implements RemoteUserExtractor {
    private final String parameter;

    public HttpQueryStringParameterRemoteUserExtractor(String parameter) {
        this.parameter = Objects.requireNonNull(parameter);
    }

    @Override
    public String extract(HttpServletRequest request) throws RemoteUserExtractionException {
        String remoteUser = request.getParameter(this.parameter);
        if (remoteUser == null) {
            throw new RemoteUserExtractionException("Failed to extract user from HTTP query string parameter: " + this.parameter);
        }
        return remoteUser;
    }
}

