/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tools.apt.model;

import java.util.Set;
import org.apache.camel.tools.apt.helper.Strings;

public final class ComponentOption {
    private String name;
    private String displayName;
    private String type;
    private String required;
    private String defaultValue;
    private String defaultValueNote;
    private String documentation;
    private boolean deprecated;
    private String deprecationNode;
    private boolean secret;
    private String group;
    private String label;
    private boolean enumType;
    private Set<String> enums;

    public ComponentOption(String name, String displayName, String type, String required, String defaultValue, String defaultValueNote, String documentation, boolean deprecated, String deprecationNode, boolean secret, String group, String label, boolean enumType, Set<String> enums) {
        this.name = name;
        this.displayName = displayName;
        this.type = type;
        this.required = required;
        this.defaultValue = defaultValue;
        this.defaultValueNote = defaultValueNote;
        this.documentation = documentation;
        this.deprecated = deprecated;
        this.deprecationNode = deprecationNode;
        this.secret = secret;
        this.group = group;
        this.label = label;
        this.enumType = enumType;
        this.enums = enums;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getType() {
        return this.type;
    }

    public String getRequired() {
        return this.required;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public String getDeprecationNode() {
        return this.deprecationNode;
    }

    public boolean isSecret() {
        return this.secret;
    }

    public String getDocumentationWithNotes() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.documentation);
        if (!Strings.isNullOrEmpty(this.defaultValueNote)) {
            sb.append(". Default value notice: ").append(this.defaultValueNote);
        }
        if (!Strings.isNullOrEmpty(this.deprecationNode)) {
            sb.append(". Deprecation note: ").append(this.deprecationNode);
        }
        return sb.toString();
    }

    public boolean isEnumType() {
        return this.enumType;
    }

    public Set<String> getEnums() {
        return this.enums;
    }

    public String getGroup() {
        return this.group;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentOption that = (ComponentOption)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

