/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.activemq;

import jakarta.jms.ConnectionFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.activemq.ActiveMQComponent;
import org.apache.camel.component.jms.JmsConfiguration;
import org.apache.camel.support.ObjectHelper;
import org.springframework.jms.connection.CachingConnectionFactory;
import org.springframework.jms.connection.DelegatingConnectionFactory;
import org.springframework.jms.connection.JmsTransactionManager;
import org.springframework.jms.connection.SingleConnectionFactory;
import org.springframework.transaction.PlatformTransactionManager;

public class ActiveMQConfiguration
extends JmsConfiguration {
    private ActiveMQComponent activeMQComponent;
    private String brokerURL = ActiveMQConnectionFactory.DEFAULT_BROKER_URL;
    private volatile boolean customBrokerURL;
    private boolean useSingleConnection;
    private boolean usePooledConnection = true;
    private boolean trustAllPackages;

    public String getBrokerURL() {
        return this.brokerURL;
    }

    public void setBrokerURL(String brokerURL) {
        this.brokerURL = brokerURL;
        this.customBrokerURL = true;
    }

    public boolean isUseSingleConnection() {
        return this.useSingleConnection;
    }

    @Deprecated(since="3.0.0")
    public String getUserName() {
        return this.getUsername();
    }

    @Deprecated(since="3.0.0")
    public void setUserName(String userName) {
        this.setUsername(userName);
    }

    public void setUseSingleConnection(boolean useSingleConnection) {
        this.useSingleConnection = useSingleConnection;
    }

    public boolean isUsePooledConnection() {
        return this.usePooledConnection;
    }

    public void setUsePooledConnection(boolean usePooledConnection) {
        this.usePooledConnection = usePooledConnection;
    }

    public boolean isTrustAllPackages() {
        return this.trustAllPackages;
    }

    public void setTrustAllPackages(boolean trustAllPackages) {
        this.trustAllPackages = trustAllPackages;
    }

    protected PlatformTransactionManager createTransactionManager() {
        JmsTransactionManager answer = new JmsTransactionManager(this.getOrCreateConnectionFactory());
        answer.afterPropertiesSet();
        return answer;
    }

    protected void setActiveMQComponent(ActiveMQComponent activeMQComponent) {
        this.activeMQComponent = activeMQComponent;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        ActiveMQConnectionFactory acf = null;
        ConnectionFactory target = connectionFactory;
        if (target instanceof CachingConnectionFactory) {
            CachingConnectionFactory ccf = (CachingConnectionFactory)target;
            target = ccf.getTargetConnectionFactory();
        }
        if (target instanceof DelegatingConnectionFactory) {
            DelegatingConnectionFactory dcf = (DelegatingConnectionFactory)target;
            target = dcf.getTargetConnectionFactory();
        }
        if (target instanceof ActiveMQConnectionFactory) {
            acf = (ActiveMQConnectionFactory)target;
        }
        if (acf != null) {
            if (this.customBrokerURL) {
                acf.setBrokerURL(this.brokerURL);
            } else {
                this.setBrokerURL(acf.getBrokerURL());
            }
        }
        super.setConnectionFactory(connectionFactory);
    }

    protected ConnectionFactory createConnectionFactory() {
        CamelContext context;
        ActiveMQConnectionFactory answer = new ActiveMQConnectionFactory();
        answer.setTrustAllPackages(this.trustAllPackages);
        if (this.getUsername() != null) {
            answer.setUserName(this.getUsername());
        }
        if (this.getPassword() != null) {
            answer.setPassword(this.getPassword());
        }
        answer.setBrokerURL(this.getBrokerURL());
        CamelContext camelContext = context = this.activeMQComponent != null ? this.activeMQComponent.getCamelContext() : null;
        if (this.isUseSingleConnection()) {
            SingleConnectionFactory scf = new SingleConnectionFactory((ConnectionFactory)answer);
            if (this.activeMQComponent != null) {
                this.activeMQComponent.addSingleConnectionFactory(scf);
            }
            return scf;
        }
        if (this.isUsePooledConnection()) {
            ConnectionFactory pcf = this.createPooledConnectionFactory(context, answer);
            if (this.activeMQComponent != null) {
                this.activeMQComponent.addPooledConnectionFactoryService(pcf);
            }
            return pcf;
        }
        return answer;
    }

    protected ConnectionFactory createPooledConnectionFactory(CamelContext camelContext, ActiveMQConnectionFactory connectionFactory) {
        try {
            Class<?> type = ActiveMQConfiguration.loadClass(camelContext, "org.messaginghub.pooled.jms.JmsPoolConnectionFactory", ((Object)((Object)this)).getClass().getClassLoader());
            Constructor<?> constructor = type.getConstructor(new Class[0]);
            ConnectionFactory cf = (ConnectionFactory)constructor.newInstance(new Object[0]);
            ObjectHelper.invokeMethod((Method)type.getDeclaredMethod("setConnectionFactory", Object.class), (Object)cf, (Object[])new Object[]{connectionFactory});
            return cf;
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Failed to instantiate PooledConnectionFactory: " + e, (Throwable)e);
        }
    }

    public static Class<?> loadClass(CamelContext camelContext, String name, ClassLoader loader) throws ClassNotFoundException {
        if (camelContext != null) {
            return camelContext.getClassResolver().resolveMandatoryClass("org.messaginghub.pooled.jms.JmsPoolConnectionFactory");
        }
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            try {
                return contextClassLoader.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                return loader.loadClass(name);
            }
        }
        return loader.loadClass(name);
    }
}

