/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ahc;

import java.util.Map;
import org.apache.camel.CamelException;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;

public class AhcOperationFailedException
extends CamelException {
    private static final long serialVersionUID = -6731281444593522633L;
    private final String url;
    private final String redirectLocation;
    private final int statusCode;
    private final String statusText;
    private final Map<String, String> responseHeaders;
    private final String responseBody;

    public AhcOperationFailedException(String url, int statusCode, String statusText, String location, Map<String, String> responseHeaders, String responseBody) {
        super("HTTP operation failed invoking " + URISupport.sanitizeUri((String)url) + " with statusCode: " + statusCode + (location != null ? ", redirectLocation: " + location : ""));
        this.url = URISupport.sanitizeUri((String)url);
        this.statusCode = statusCode;
        this.statusText = statusText;
        this.redirectLocation = location;
        this.responseHeaders = responseHeaders;
        this.responseBody = responseBody;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isRedirectError() {
        return this.statusCode >= 300 && this.statusCode < 400;
    }

    public boolean hasRedirectLocation() {
        return ObjectHelper.isNotEmpty((Object)this.redirectLocation);
    }

    public String getRedirectLocation() {
        return this.redirectLocation;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }

    public String getResponseBody() {
        return this.responseBody;
    }
}

