/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ahc;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.Request;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.ahc.AhcEndpoint;
import org.apache.camel.impl.DefaultAsyncProducer;

public class AhcProducer
extends DefaultAsyncProducer {
    private final AsyncHttpClient client;

    public AhcProducer(AhcEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.client = endpoint.getClient();
    }

    public AhcEndpoint getEndpoint() {
        return (AhcEndpoint)super.getEndpoint();
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            Request request = this.getEndpoint().getBinding().prepareRequest(this.getEndpoint(), exchange);
            this.log.debug("Executing request {} ", (Object)request);
            this.client.prepareRequest(request).execute((AsyncHandler)new AhcAsyncHandler(exchange, callback, request.getUrl()));
            return false;
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
            callback.done(true);
            return true;
        }
    }

    private final class AhcAsyncHandler
    implements AsyncHandler<Exchange> {
        private final Exchange exchange;
        private final AsyncCallback callback;
        private final String url;
        private final ByteArrayOutputStream os;
        private int contentLength;
        private int statusCode;
        private String statusText;

        private AhcAsyncHandler(Exchange exchange, AsyncCallback callback, String url) {
            this.exchange = exchange;
            this.callback = callback;
            this.url = url;
            this.os = new ByteArrayOutputStream();
        }

        public void onThrowable(Throwable t) {
            AhcProducer.this.log.trace("{} onThrowable {}", (Object)this.exchange.getExchangeId(), (Object)t);
            try {
                AhcProducer.this.getEndpoint().getBinding().onThrowable(AhcProducer.this.getEndpoint(), this.exchange, t);
            }
            catch (Exception e) {
                this.exchange.setException((Throwable)e);
            }
            this.callback.done(false);
        }

        public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
            int wrote = bodyPart.writeTo((OutputStream)this.os);
            AhcProducer.this.log.trace("{} onBodyPartReceived {} bytes", (Object)this.exchange.getExchangeId(), (Object)wrote);
            this.contentLength += wrote;
            return AsyncHandler.STATE.CONTINUE;
        }

        public AsyncHandler.STATE onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
            AhcProducer.this.log.trace("{} onStatusReceived {}", (Object)this.exchange.getExchangeId(), (Object)responseStatus);
            try {
                this.statusCode = responseStatus.getStatusCode();
                this.statusText = responseStatus.getStatusText();
                AhcProducer.this.getEndpoint().getBinding().onStatusReceived(AhcProducer.this.getEndpoint(), this.exchange, responseStatus);
            }
            catch (Exception e) {
                this.exchange.setException((Throwable)e);
            }
            return AsyncHandler.STATE.CONTINUE;
        }

        public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers) throws Exception {
            AhcProducer.this.log.trace("{} onHeadersReceived {}", (Object)this.exchange.getExchangeId(), (Object)headers);
            try {
                AhcProducer.this.getEndpoint().getBinding().onHeadersReceived(AhcProducer.this.getEndpoint(), this.exchange, headers);
            }
            catch (Exception e) {
                this.exchange.setException((Throwable)e);
            }
            return AsyncHandler.STATE.CONTINUE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Exchange onCompleted() throws Exception {
            AhcProducer.this.log.trace("{} onCompleted", (Object)this.exchange.getExchangeId());
            try {
                AhcProducer.this.getEndpoint().getBinding().onComplete(AhcProducer.this.getEndpoint(), this.exchange, this.url, this.os, this.contentLength, this.statusCode, this.statusText);
            }
            catch (Exception e) {
                this.exchange.setException((Throwable)e);
            }
            finally {
                this.callback.done(false);
            }
            return this.exchange;
        }

        public String toString() {
            return "AhcAsyncHandler for exchangeId: " + this.exchange.getExchangeId() + " -> " + this.url;
        }
    }
}

