/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spi;

import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Message;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeTransformer;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;

public abstract class Transformer
extends ServiceSupport
implements CamelContextAware {
    private CamelContext camelContext;
    private String name;
    private DataType from;
    private DataType to;

    public Transformer() {
        if (this.getClass().isAnnotationPresent(DataTypeTransformer.class)) {
            DataTypeTransformer annotation = this.getClass().getAnnotation(DataTypeTransformer.class);
            if (ObjectHelper.isNotEmpty((String)annotation.name())) {
                this.name = annotation.name();
            }
            if (ObjectHelper.isNotEmpty((String)annotation.fromType())) {
                this.from = new DataType(annotation.fromType());
            }
            if (ObjectHelper.isNotEmpty((String)annotation.toType())) {
                this.to = new DataType(annotation.toType());
            }
        }
    }

    public Transformer(String name) {
        this.name = name;
    }

    public abstract void transform(Message var1, DataType var2, DataType var3) throws Exception;

    public String getName() {
        return this.name;
    }

    public DataType getFrom() {
        return this.from;
    }

    public DataType getTo() {
        return this.to;
    }

    public Transformer setName(String name) {
        this.name = name;
        return this;
    }

    public Transformer setName(String scheme, String name) {
        this.name = ObjectHelper.isNotEmpty((String)scheme) ? (ObjectHelper.isNotEmpty((String)name) ? scheme + ":" + name : scheme) : name;
        return this;
    }

    public Transformer setFrom(String from) {
        this.from = new DataType(from);
        return this;
    }

    public Transformer setTo(String to) {
        this.to = new DataType(to);
        return this;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext context) {
        this.camelContext = context;
    }

    public String toString() {
        return String.format("%s[name='%s', from='%s', to='%s']", this.getClass().getSimpleName(), this.name, this.from, this.to);
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
    }
}

