/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel;

import org.apache.camel.Exchange;
import org.apache.camel.LineNumberAware;

public interface NamedNode
extends LineNumberAware {
    public String getId();

    public String getNodePrefixId();

    public String getShortName();

    public String getLabel();

    public String getDescriptionText();

    public NamedNode getParent();

    default public boolean acceptDebugger(Exchange exchange) {
        return true;
    }

    default public int getLevel() {
        NamedNode node = this;
        int level = 0;
        while (node != null && node.getParent() != null) {
            boolean shallow = "when".equals(node.getShortName()) || "otherwise".equals(node.getShortName());
            node = node.getParent();
            if (shallow) continue;
            ++level;
        }
        return level;
    }

    default public String getParentId() {
        for (NamedNode node = this; node != null && node.getParent() != null; node = node.getParent()) {
            boolean shallow = "when".equals(node.getShortName()) || "otherwise".equals(node.getShortName());
            if (shallow) continue;
            return node.getId();
        }
        return null;
    }

    default public NamedNode findMatchingWhen(String id) {
        return null;
    }

    default public NamedNode findMatchingOtherwise(String id) {
        return null;
    }
}

