/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api.entity;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.camel.component.as2.api.CanonicalOutputStream;
import org.apache.camel.component.as2.api.entity.MimeEntity;
import org.apache.camel.component.as2.api.util.EntityUtils;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpException;
import org.apache.http.entity.ContentType;
import org.apache.http.util.Args;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;

public class ApplicationPkcs7SignatureEntity
extends MimeEntity {
    private static final String CONTENT_DISPOSITION = "attachment; filename=\"smime.p7s\"";
    private static final String CONTENT_DESCRIPTION = "S/MIME Cryptographic Signature";
    private byte[] signature;

    public ApplicationPkcs7SignatureEntity(MimeEntity data, CMSSignedDataGenerator signer, String charset, String contentTransferEncoding, boolean isMainBody) throws HttpException {
        Args.notNull((Object)((Object)data), (String)"Data");
        Args.notNull((Object)signer, (String)"Signer");
        ContentType contentType = ContentType.parse((String)EntityUtils.appendParameter("application/pkcs7-signature; name=smime.p7s; smime-type=signed-data", "charset", charset));
        this.setContentType(contentType.toString());
        this.setContentTransferEncoding(contentTransferEncoding);
        this.addHeader("Content-Disposition", CONTENT_DISPOSITION);
        this.addHeader("Content-Description", CONTENT_DESCRIPTION);
        this.setMainBody(isMainBody);
        try {
            this.signature = this.createSignature(data, signer);
        }
        catch (Exception e) {
            throw new HttpException("Failed to create signed data", (Throwable)e);
        }
    }

    public ApplicationPkcs7SignatureEntity(byte[] signature, String charset, String contentTransferEncoding, boolean isMainBody) {
        this.signature = (byte[])Args.notNull((Object)signature, (String)"signature");
        ContentType contentType = ContentType.parse((String)EntityUtils.appendParameter("application/pkcs7-signature; name=smime.p7s; smime-type=signed-data", "charset", charset));
        this.setContentType(contentType.toString());
        this.setContentTransferEncoding(contentTransferEncoding);
        this.addHeader("Content-Disposition", CONTENT_DISPOSITION);
        this.addHeader("Content-Description", CONTENT_DESCRIPTION);
        this.setMainBody(isMainBody);
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public void writeTo(OutputStream outstream) throws IOException {
        MimeEntity.NoCloseOutputStream ncos = new MimeEntity.NoCloseOutputStream(outstream);
        if (!this.isMainBody()) {
            try (CanonicalOutputStream canonicalOutstream = new CanonicalOutputStream(ncos, "US-ASCII");){
                HeaderIterator it = this.headerIterator();
                while (it.hasNext()) {
                    Header header = it.nextHeader();
                    canonicalOutstream.writeln(header.toString());
                }
                canonicalOutstream.writeln();
            }
        }
        String transferEncoding = this.getContentTransferEncoding() == null ? null : this.getContentTransferEncoding().getValue();
        try (OutputStream transferEncodedStream = EntityUtils.encode(ncos, transferEncoding);){
            transferEncodedStream.write(this.signature);
        }
        catch (Exception e) {
            throw new IOException("Failed to write to output stream", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] createSignature(MimeEntity data, CMSSignedDataGenerator signer) throws Exception {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            data.writeTo(bos);
            bos.flush();
            CMSProcessableByteArray contentData = new CMSProcessableByteArray(bos.toByteArray());
            CMSSignedData signedData = signer.generate((CMSTypedData)contentData, false);
            byte[] byArray = signedData.getEncoded();
            return byArray;
        }
        catch (Exception e) {
            throw new Exception("", e);
        }
    }
}

