/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api.entity;

import java.util.HashMap;
import org.apache.camel.component.as2.api.entity.DispositionNotificationOptions;
import org.apache.camel.component.as2.api.util.AS2HeaderUtils;
import org.apache.http.ParseException;
import org.apache.http.message.ParserCursor;
import org.apache.http.util.Args;
import org.apache.http.util.CharArrayBuffer;

public class DispositionNotificationOptionsParser {
    public static final DispositionNotificationOptionsParser INSTANCE = new DispositionNotificationOptionsParser();
    private static final String SIGNED_RECEIPT_PROTOCOL_ATTR_NAME = "signed-receipt-protocol";
    private static final String SIGNED_RECEIPT_MICALG_ATTR_NAME = "signed-receipt-micalg";

    public static DispositionNotificationOptions parseDispositionNotificationOptions(String value, DispositionNotificationOptionsParser parser) throws ParseException {
        if (value == null) {
            return new DispositionNotificationOptions(null, null);
        }
        CharArrayBuffer buffer = new CharArrayBuffer(value.length());
        buffer.append(value);
        ParserCursor cursor = new ParserCursor(0, value.length());
        return (parser != null ? parser : INSTANCE).parseDispositionNotificationOptions(buffer, cursor);
    }

    public DispositionNotificationOptions parseDispositionNotificationOptions(CharArrayBuffer buffer, ParserCursor cursor) {
        Args.notNull((Object)buffer, (String)"buffer");
        Args.notNull((Object)cursor, (String)"cursor");
        HashMap<String, AS2HeaderUtils.Parameter> parameters = new HashMap<String, AS2HeaderUtils.Parameter>();
        while (!cursor.atEnd()) {
            AS2HeaderUtils.Parameter parameter = AS2HeaderUtils.parseParameter(buffer, cursor);
            parameters.put(parameter.getAttribute(), parameter);
        }
        AS2HeaderUtils.Parameter signedReceiptProtocolParameter = (AS2HeaderUtils.Parameter)parameters.get(SIGNED_RECEIPT_PROTOCOL_ATTR_NAME);
        AS2HeaderUtils.Parameter signedReceiptMicalgParameter = (AS2HeaderUtils.Parameter)parameters.get(SIGNED_RECEIPT_MICALG_ATTR_NAME);
        return new DispositionNotificationOptions(signedReceiptProtocolParameter, signedReceiptMicalgParameter);
    }
}

