/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api.entity;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.HeaderGroup;
import org.apache.http.util.Args;

public abstract class MimeEntity
extends AbstractHttpEntity {
    protected static final long UNKNOWN_CONTENT_LENGTH = -1L;
    protected static final long RECALCULATE_CONTENT_LENGTH = -2L;
    protected boolean isMainBody;
    protected Header contentTransferEncoding;
    protected long contentLength = -2L;
    private final HeaderGroup headergroup = new HeaderGroup();

    protected MimeEntity() {
    }

    public boolean isMainBody() {
        return this.isMainBody;
    }

    public void setMainBody(boolean isMainBody) {
        this.isMainBody = isMainBody;
    }

    public String getContentTypeValue() {
        Header contentTypeHeader = this.getContentType();
        if (contentTypeHeader != null) {
            return contentTypeHeader.getValue();
        }
        return null;
    }

    public void setContentType(ContentType contentType) {
        super.setContentType(contentType == null ? null : contentType.toString());
    }

    public void setContentType(Header contentType) {
        super.setContentType(contentType);
        if (contentType != null) {
            this.addHeader(contentType);
        } else {
            this.removeHeaders("Content-Type");
        }
    }

    public String getContentEncodingValue() {
        Header contentEncodingHeader = this.getContentEncoding();
        if (contentEncodingHeader != null) {
            return contentEncodingHeader.getValue();
        }
        return null;
    }

    public void setContentEncoding(Header contentEncoding) {
        super.setContentEncoding(contentEncoding);
        if (contentEncoding != null) {
            this.addHeader(contentEncoding);
        } else {
            this.removeHeaders("Content-Encoding");
        }
    }

    public String getContentTransferEncodingValue() {
        Header contentTransferEncodingHeader = this.getContentTransferEncoding();
        if (contentTransferEncodingHeader != null) {
            return contentTransferEncodingHeader.getValue();
        }
        return null;
    }

    public Header getContentTransferEncoding() {
        return this.contentTransferEncoding;
    }

    public void setContentTransferEncoding(Header contentTransferEncoding) {
        this.contentTransferEncoding = contentTransferEncoding;
        if (contentTransferEncoding != null) {
            this.addHeader(contentTransferEncoding);
        } else {
            this.removeHeaders("Content-Transfer-Encoding");
        }
    }

    public void setContentTransferEncoding(String contentTranserEncoding) {
        BasicHeader h = null;
        if (contentTranserEncoding != null) {
            h = new BasicHeader("Content-Transfer-Encoding", contentTranserEncoding);
        }
        this.setContentTransferEncoding((Header)h);
    }

    public boolean containsHeader(String name) {
        return this.headergroup.containsHeader(name);
    }

    public Header[] getHeaders(String name) {
        return this.headergroup.getHeaders(name);
    }

    public Header getFirstHeader(String name) {
        return this.headergroup.getFirstHeader(name);
    }

    public Header getLastHeader(String name) {
        return this.headergroup.getLastHeader(name);
    }

    public Header[] getAllHeaders() {
        return this.headergroup.getAllHeaders();
    }

    public void addHeader(Header header) {
        this.headergroup.addHeader(header);
    }

    public void addHeader(String name, String value) {
        Args.notNull((Object)name, (String)"Header name");
        this.headergroup.addHeader((Header)new BasicHeader(name, value));
    }

    public void setHeader(Header header) {
        this.headergroup.updateHeader(header);
    }

    public void setHeader(String name, String value) {
        Args.notNull((Object)name, (String)"Header name");
        this.headergroup.updateHeader((Header)new BasicHeader(name, value));
    }

    public void setHeaders(Header[] headers) {
        this.headergroup.setHeaders(headers);
    }

    public void removeHeader(Header header) {
        this.headergroup.removeHeader(header);
    }

    public void removeHeaders(String name) {
        if (name == null) {
            return;
        }
        HeaderIterator i = this.headergroup.iterator();
        while (i.hasNext()) {
            Header header = i.nextHeader();
            if (!name.equalsIgnoreCase(header.getName())) continue;
            i.remove();
        }
    }

    public void removeAllHeaders() {
        this.headergroup.clear();
    }

    public HeaderIterator headerIterator() {
        return this.headergroup.iterator();
    }

    public HeaderIterator headerIterator(String name) {
        return this.headergroup.iterator(name);
    }

    public boolean isRepeatable() {
        return true;
    }

    public boolean isStreaming() {
        return !this.isRepeatable();
    }

    public long getContentLength() {
        if (this.contentLength == -2L) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                this.writeTo(out);
                this.contentLength = out.toByteArray().length;
            }
            catch (IOException e) {
                this.contentLength = -1L;
            }
        }
        return this.contentLength;
    }

    public InputStream getContent() throws IOException, UnsupportedOperationException {
        ByteArrayOutputStream outstream = new ByteArrayOutputStream();
        this.writeTo(outstream);
        outstream.flush();
        return new ByteArrayInputStream(outstream.toByteArray());
    }

    public String getCharset() {
        if (this.getContentType() == null) {
            return StandardCharsets.US_ASCII.name();
        }
        ContentType contentType = ContentType.parse((String)this.getContentType().getValue());
        Charset charset = contentType.getCharset();
        if (charset != null) {
            return charset.name();
        }
        return StandardCharsets.US_ASCII.name();
    }

    protected static class NoCloseOutputStream
    extends FilterOutputStream {
        public NoCloseOutputStream(OutputStream os) {
            super(os);
        }

        @Override
        public void close() {
        }
    }
}

