/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api;

public enum AS2MicAlgorithm {
    SHA_1("SHA-1", "sha1"),
    MD5("MD5", "md5");

    private final String jdkAlgorithmName;
    private final String as2AlgorithmName;

    private AS2MicAlgorithm(String jdkAlgorithmName, String as2AlgorithmName) {
        this.jdkAlgorithmName = jdkAlgorithmName;
        this.as2AlgorithmName = as2AlgorithmName;
    }

    public String getJdkAlgorithmName() {
        return this.jdkAlgorithmName;
    }

    public String getAs2AlgorithmName() {
        return this.as2AlgorithmName;
    }

    public static String getJdkAlgorithmName(String as2AlgorithmName) {
        switch (as2AlgorithmName) {
            case "sha1": {
                return "SHA-1";
            }
            case "md5": {
                return "MD5";
            }
        }
        return null;
    }

    public static String getAS2AlgorithmName(String jdkAlgorithmName) {
        switch (jdkAlgorithmName) {
            case "MD5": {
                return "md5";
            }
            case "SHA-1": {
                return "sha1";
            }
        }
        return null;
    }
}

