/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.asterisk;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.asterisk.AsteriskAction;
import org.apache.camel.component.asterisk.AsteriskConnection;
import org.apache.camel.component.asterisk.AsteriskEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.asteriskjava.manager.action.ManagerAction;
import org.asteriskjava.manager.response.ManagerResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsteriskProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(AsteriskProducer.class);
    private final AsteriskEndpoint endpoint;
    private final AsteriskConnection connection;

    public AsteriskProducer(AsteriskEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.connection = new AsteriskConnection(endpoint.getHostname(), endpoint.getUsername(), endpoint.getPassword());
    }

    protected void doStart() throws Exception {
        this.connection.login();
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.connection.logoff();
    }

    public void process(Exchange exchange) throws Exception {
        AsteriskAction action = (AsteriskAction)exchange.getIn().getHeader("CamelAsteriskAction", AsteriskAction.class);
        if (action == null) {
            action = this.endpoint.getAction();
        }
        ObjectHelper.notNull((Object)action, (String)"action");
        LOG.debug("Send action {}", (Object)action);
        ManagerAction managerAction = (ManagerAction)action.apply(exchange);
        ManagerResponse managerResponse = this.connection.sendAction(managerAction);
        exchange.getIn().setBody((Object)managerResponse);
    }
}

