/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atmos.validator;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.component.atmos.AtmosConfiguration;
import org.apache.camel.component.atmos.util.AtmosException;
import org.apache.camel.component.atmos.util.AtmosOperation;

public final class AtmosConfigurationValidator {
    private AtmosConfigurationValidator() {
    }

    public static void validate(AtmosConfiguration configuration) throws AtmosException {
        AtmosConfigurationValidator.validateCommonProperties(configuration);
        AtmosOperation op = configuration.getOperation();
        if (op == AtmosOperation.get) {
            AtmosConfigurationValidator.validateGetOp(configuration);
        } else if (op == AtmosOperation.put) {
            AtmosConfigurationValidator.validatePutOp(configuration);
        } else if (op == AtmosOperation.del) {
            AtmosConfigurationValidator.validateDelOp(configuration);
        } else if (op == AtmosOperation.move) {
            AtmosConfigurationValidator.validateMoveOp(configuration);
        }
    }

    private static void validateCommonProperties(AtmosConfiguration configuration) throws AtmosException {
        if (configuration.getFullTokenId() == null || configuration.getFullTokenId().equals("")) {
            throw new AtmosException("option <fullTokenId> is not present or not valid!");
        }
        if (configuration.getSecretKey() == null || configuration.getSecretKey().equals("")) {
            throw new AtmosException("option <secretKey> is not present or not valid!");
        }
        if (configuration.getUri() == null || configuration.getUri().equals("")) {
            throw new AtmosException("option <uri> is not present!");
        }
        try {
            URI uri = new URI(configuration.getUri());
        }
        catch (URISyntaxException use) {
            throw new AtmosException("option <uri> is not valid!", use);
        }
    }

    private static void validateGetOp(AtmosConfiguration configuration) throws AtmosException {
        AtmosConfigurationValidator.validateRemotePath(configuration.getRemotePath());
    }

    private static void validatePutOp(AtmosConfiguration configuration) throws AtmosException {
        AtmosConfigurationValidator.validateLocalPath(configuration.getLocalPath());
        if (configuration.getRemotePath() != null) {
            AtmosConfigurationValidator.validateRemotePathForPut(configuration.getRemotePath());
        } else {
            AtmosConfigurationValidator.validatePathInUnix(configuration.getLocalPath());
        }
    }

    private static void validateDelOp(AtmosConfiguration configuration) throws AtmosException {
        AtmosConfigurationValidator.validateRemotePath(configuration.getRemotePath());
    }

    private static void validateMoveOp(AtmosConfiguration configuration) throws AtmosException {
        AtmosConfigurationValidator.validateRemotePath(configuration.getRemotePath());
        AtmosConfigurationValidator.validateRemotePath(configuration.getNewRemotePath());
    }

    private static void validateLocalPath(String localPath) throws AtmosException {
        if (localPath == null || localPath.equals("")) {
            throw new AtmosException("option <localPath> is not present or not valid!");
        }
        File file = new File(localPath);
        if (!file.exists()) {
            throw new AtmosException("option <localPath> is not an existing file or directory!");
        }
    }

    private static void validateRemotePath(String remotePath) throws AtmosException {
        if (remotePath == null || !remotePath.startsWith("/")) {
            throw new AtmosException("option <remotePath> is not valid!");
        }
        AtmosConfigurationValidator.validatePathInUnix(remotePath);
    }

    private static void validateRemotePathForPut(String remotePath) throws AtmosException {
        if (!remotePath.startsWith("/")) {
            throw new AtmosException("option <remotePath> is not valid!");
        }
        AtmosConfigurationValidator.validatePathInUnix(remotePath);
    }

    private static void validatePathInUnix(String path) throws AtmosException {
        Pattern pattern = Pattern.compile("/*?(\\S+)/*?", 2);
        Matcher matcher = pattern.matcher(path);
        if (!matcher.matches()) {
            throw new AtmosException(path + " is not a valid path, must be in UNIX form!");
        }
    }
}

