/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atmosphere.websocket;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.component.atmosphere.websocket.MemoryWebSocketStore;
import org.apache.camel.component.atmosphere.websocket.WebSocketStore;
import org.apache.camel.component.atmosphere.websocket.WebsocketEndpoint;
import org.apache.camel.component.servlet.ServletComponent;
import org.apache.camel.component.servlet.ServletEndpoint;

public class WebsocketComponent
extends ServletComponent {
    private Map<String, WebSocketStore> stores;

    public WebsocketComponent() {
        super(WebsocketEndpoint.class);
        this.setServletName("CamelWsServlet");
        this.stores = new HashMap<String, WebSocketStore>();
    }

    protected ServletEndpoint createServletEndpoint(String endpointUri, ServletComponent component, URI httpUri) throws Exception {
        return new WebsocketEndpoint(endpointUri, (WebsocketComponent)component, httpUri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WebSocketStore getWebSocketStore(String name) {
        WebSocketStore store;
        Map<String, WebSocketStore> map = this.stores;
        synchronized (map) {
            store = this.stores.get(name);
            if (store == null) {
                store = new MemoryWebSocketStore();
                this.stores.put(name, store);
            }
        }
        return store;
    }
}

