/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atmosphere.websocket;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.component.atmosphere.websocket.WebSocketStore;
import org.atmosphere.websocket.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryWebSocketStore
implements WebSocketStore {
    private static final transient Logger LOG = LoggerFactory.getLogger(MemoryWebSocketStore.class);
    private Map<String, WebSocket> values = new ConcurrentHashMap<String, WebSocket>();
    private Map<WebSocket, String> keys = new ConcurrentHashMap<WebSocket, String>();

    public void start() throws Exception {
    }

    public void stop() throws Exception {
        this.values.clear();
        this.keys.clear();
    }

    @Override
    public void addWebSocket(String connectionKey, WebSocket websocket) {
        this.values.put(connectionKey, websocket);
        this.keys.put(websocket, connectionKey);
        if (LOG.isDebugEnabled()) {
            LOG.debug("added websocket {} => {}", (Object)connectionKey, (Object)websocket);
        }
    }

    @Override
    public void removeWebSocket(String connectionKey) {
        WebSocket obj = this.values.remove(connectionKey);
        if (obj != null) {
            this.keys.remove(obj);
        }
        LOG.debug("removed websocket {}", (Object)connectionKey);
    }

    @Override
    public void removeWebSocket(WebSocket websocket) {
        String obj = this.keys.remove(websocket);
        if (obj != null) {
            this.values.remove(obj);
        }
        LOG.debug("removed websocket {}", (Object)websocket);
    }

    @Override
    public String getConnectionKey(WebSocket websocket) {
        return this.keys.get(websocket);
    }

    @Override
    public WebSocket getWebSocket(String connectionKey) {
        return this.values.get(connectionKey);
    }

    @Override
    public Collection<WebSocket> getAllWebSockets() {
        return this.values.values();
    }
}

