/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atmosphere.websocket;

import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.component.atmosphere.websocket.MemoryWebSocketStore;
import org.apache.camel.component.atmosphere.websocket.WebSocketStore;
import org.apache.camel.component.atmosphere.websocket.WebsocketEndpoint;
import org.apache.camel.component.servlet.ServletComponent;
import org.apache.camel.component.servlet.ServletEndpoint;
import org.apache.camel.spi.annotations.Component;

@Component(value="atmosphere-websocket")
public class WebsocketComponent
extends ServletComponent {
    private final Map<String, WebSocketStore> stores;

    public WebsocketComponent() {
        super(WebsocketEndpoint.class);
        this.setServletName("CamelWsServlet");
        this.stores = new ConcurrentHashMap<String, WebSocketStore>();
    }

    protected ServletEndpoint createServletEndpoint(String endpointUri, ServletComponent component, URI httpUri) throws Exception {
        return new WebsocketEndpoint(endpointUri, (WebsocketComponent)component, httpUri);
    }

    WebSocketStore getWebSocketStore(String name) {
        return this.stores.computeIfAbsent(name, k -> new MemoryWebSocketStore());
    }
}

