/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.avro;

import org.apache.avro.ipc.Callback;
import org.apache.avro.ipc.Requestor;
import org.apache.avro.ipc.Transceiver;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.avro.AvroConfiguration;
import org.apache.camel.component.avro.AvroEndpoint;
import org.apache.camel.component.avro.AvroReflectRequestor;
import org.apache.camel.component.avro.AvroSpecificRequestor;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.commons.lang3.StringUtils;

public abstract class AvroProducer
extends DefaultAsyncProducer {
    Transceiver transceiver;
    Requestor requestor;

    public AvroProducer(Endpoint endpoint) {
        super(endpoint);
    }

    public boolean isSingleton() {
        return false;
    }

    public abstract Transceiver createTransceiver() throws Exception;

    public boolean process(final Exchange exchange, final AsyncCallback callback) {
        Object request = exchange.getIn().getBody();
        try {
            String messageName = !StringUtils.isEmpty((CharSequence)((CharSequence)exchange.getIn().getHeader("CamelAvroMessageName", String.class))) ? (String)exchange.getIn().getHeader("CamelAvroMessageName", String.class) : this.getEndpoint().getConfiguration().getMessageName();
            this.requestor.request(messageName, (Object)this.wrapObjectToArray(request), (Callback)new Callback<Object>(){

                public void handleResult(Object result) {
                    try {
                        exchange.getOut().setHeaders(exchange.getIn().getHeaders());
                        exchange.getOut().setBody(result);
                    }
                    finally {
                        callback.done(false);
                    }
                }

                public void handleError(Throwable error) {
                    try {
                        exchange.setException(error);
                    }
                    finally {
                        callback.done(false);
                    }
                }
            });
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
            callback.done(true);
            return true;
        }
        return false;
    }

    public Object[] wrapObjectToArray(Object object) {
        if (object instanceof Object[]) {
            return (Object[])object;
        }
        Object[] wrapper = new Object[]{object};
        return wrapper;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.transceiver = this.createTransceiver();
        AvroConfiguration configuration = this.getEndpoint().getConfiguration();
        this.requestor = configuration.isReflectionProtocol() ? new AvroReflectRequestor(configuration.getProtocol(), this.transceiver) : new AvroSpecificRequestor(configuration.getProtocol(), this.transceiver);
    }

    protected void doStop() throws Exception {
        if (this.transceiver != null) {
            this.transceiver.close();
            this.transceiver = null;
        }
        this.requestor = null;
        super.doStop();
    }

    public AvroEndpoint getEndpoint() {
        return (AvroEndpoint)super.getEndpoint();
    }
}

