/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.avro;

import java.net.InetSocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.ipc.Responder;
import org.apache.avro.ipc.Server;
import org.apache.avro.ipc.netty.NettyServer;
import org.apache.avro.ipc.specific.SpecificResponder;
import org.apache.avro.specific.SpecificData;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.avro.AvroComponentException;
import org.apache.camel.component.avro.AvroConfiguration;
import org.apache.camel.component.avro.AvroConsumer;
import org.apache.camel.component.avro.AvroEndpoint;
import org.apache.camel.component.avro.AvroReflectResponder;
import org.apache.camel.component.avro.AvroSpecificResponder;
import org.apache.camel.component.avro.spi.AvroRpcHttpServerFactory;
import org.apache.camel.support.ExchangeHelper;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(AvroListener.class);
    private final ConcurrentMap<String, AvroConsumer> consumerRegistry = new ConcurrentHashMap<String, AvroConsumer>();
    private AvroConsumer defaultConsumer;
    private final Server server;

    public AvroListener(AvroEndpoint endpoint) throws Exception {
        this.server = this.initAndStartServer(endpoint.getConfiguration(), endpoint.getCamelContext());
    }

    private Server initAndStartServer(AvroConfiguration configuration, CamelContext camelContext) throws Exception {
        Object responder = configuration.isReflectionProtocol() ? new AvroReflectResponder(configuration.getProtocol(), this) : new AvroSpecificResponder(configuration.getProtocol(), this);
        Server newServer = AvroListener.createServer(configuration, camelContext, (SpecificResponder)responder);
        newServer.start();
        return newServer;
    }

    private static Server createServer(AvroConfiguration configuration, CamelContext camelContext, SpecificResponder responder) throws Exception {
        if ("http".equalsIgnoreCase(configuration.getTransport().name())) {
            AvroRpcHttpServerFactory factory = (AvroRpcHttpServerFactory)camelContext.getCamelContextExtension().getFactoryFinder("META-INF/services/org/apache/camel/").newInstance("avro-rpc-http-server-factory", AvroRpcHttpServerFactory.class).orElseThrow(() -> new IllegalStateException("AvroRpcHttpServerFactory is neither set on this endpoint neither found in Camel Registry or FactoryFinder."));
            return factory.create(responder, configuration.getPort());
        }
        if ("netty".equalsIgnoreCase(configuration.getTransport().name())) {
            return new NettyServer((Responder)responder, new InetSocketAddress(configuration.getHost(), configuration.getPort()));
        }
        throw new IllegalArgumentException("Unknown transport " + configuration.getTransport());
    }

    public void register(String messageName, AvroConsumer consumer) throws AvroComponentException {
        if (messageName == null) {
            if (this.defaultConsumer != null) {
                throw new AvroComponentException("Default consumer already registered for uri: " + consumer.getEndpoint().getEndpointUri());
            }
            this.defaultConsumer = consumer;
        } else if (this.consumerRegistry.putIfAbsent(messageName, consumer) != null) {
            throw new AvroComponentException("Consumer already registered for message: " + messageName + " and uri: " + consumer.getEndpoint().getEndpointUri());
        }
    }

    public boolean unregister(String messageName) {
        if (!StringUtils.isEmpty((CharSequence)messageName)) {
            if (this.consumerRegistry.remove(messageName) == null) {
                LOGGER.warn("Consumer with message name {} was already unregistered.", (Object)messageName);
            }
        } else {
            this.defaultConsumer = null;
        }
        if (this.defaultConsumer == null && this.consumerRegistry.isEmpty()) {
            if (this.server != null) {
                this.server.close();
            }
            return true;
        }
        return false;
    }

    public Object respond(Protocol.Message message, Object request, SpecificData data) throws Exception {
        AvroConsumer consumer = this.defaultConsumer;
        if (this.consumerRegistry.containsKey(message.getName())) {
            consumer = (AvroConsumer)((Object)this.consumerRegistry.get(message.getName()));
        }
        if (consumer == null) {
            throw new AvroComponentException("No consumer defined for message: " + message.getName());
        }
        Object params = AvroListener.extractParams(message, request, consumer.getEndpoint().getConfiguration().isSingleParameter(), data);
        return AvroListener.processExchange(consumer, message, params);
    }

    private static Object extractParams(Protocol.Message message, Object request, boolean singleParameter, SpecificData dataResolver) {
        if (singleParameter) {
            Schema.Field field = (Schema.Field)message.getRequest().getFields().get(0);
            return dataResolver.getField(request, field.name(), field.pos());
        }
        int i = 0;
        Object[] params = new Object[message.getRequest().getFields().size()];
        for (Schema.Field param : message.getRequest().getFields()) {
            params[i] = dataResolver.getField(request, param.name(), param.pos());
            ++i;
        }
        return params;
    }

    private static Object processExchange(AvroConsumer consumer, Protocol.Message message, Object params) throws Exception {
        Exchange exchange = AvroListener.createExchange(consumer, message, params);
        try {
            consumer.getProcessor().process(exchange);
        }
        catch (Exception e) {
            consumer.getExceptionHandler().handleException((Throwable)e);
        }
        Object response = ExchangeHelper.isOutCapable((Exchange)exchange) ? exchange.getOut().getBody() : null;
        boolean failed = exchange.isFailed();
        if (failed) {
            if (exchange.getException() != null) {
                throw exchange.getException();
            }
            throw new AvroComponentException("Camel processing error.");
        }
        return response;
    }

    protected static Exchange createExchange(AvroConsumer consumer, Protocol.Message message, Object request) {
        ExchangePattern pattern = ExchangePattern.InOut;
        if (message.getResponse().getType().equals((Object)Schema.Type.NULL)) {
            pattern = ExchangePattern.InOnly;
        }
        Exchange exchange = consumer.createExchange(true);
        exchange.setPattern(pattern);
        exchange.getIn().setBody(request);
        exchange.getIn().setHeader("CamelAvroMessageName", (Object)message.getName());
        return exchange;
    }
}

