/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.bedrock.agent;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws2.bedrock.agent.BedrockAgentComponent;
import org.apache.camel.component.aws2.bedrock.agent.BedrockAgentConfiguration;
import org.apache.camel.component.aws2.bedrock.agent.BedrockAgentIngestionJobConsumer;
import org.apache.camel.component.aws2.bedrock.agent.BedrockAgentProducer;
import org.apache.camel.component.aws2.bedrock.agent.client.BedrockAgentClientFactory;
import org.apache.camel.component.aws2.bedrock.agentruntime.BedrockAgentRuntimeConstants;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.services.bedrockagent.BedrockAgentClient;

@UriEndpoint(firstVersion="4.5.0", scheme="aws-bedrock-agent", title="AWS Bedrock Agent", syntax="aws-bedrock-agent:label", category={Category.AI, Category.CLOUD}, headersClass=BedrockAgentRuntimeConstants.class)
public class BedrockAgentEndpoint
extends ScheduledPollEndpoint {
    private BedrockAgentClient bedrockAgentClient;
    @UriParam
    private BedrockAgentConfiguration configuration;

    public BedrockAgentEndpoint(String uri, Component component, BedrockAgentConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        BedrockAgentIngestionJobConsumer consumer = new BedrockAgentIngestionJobConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public Producer createProducer() throws Exception {
        return new BedrockAgentProducer((Endpoint)this);
    }

    public BedrockAgentComponent getComponent() {
        return (BedrockAgentComponent)super.getComponent();
    }

    public void doStart() throws Exception {
        super.doStart();
        this.bedrockAgentClient = this.configuration.getBedrockAgentClient() != null ? this.configuration.getBedrockAgentClient() : BedrockAgentClientFactory.getBedrockAgentClient(this.configuration).getBedrockAgentClient();
    }

    public void doStop() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.configuration.getBedrockAgentClient()) && this.bedrockAgentClient != null) {
            this.bedrockAgentClient.close();
        }
        super.doStop();
    }

    public BedrockAgentConfiguration getConfiguration() {
        return this.configuration;
    }

    public BedrockAgentClient getBedrockAgentClient() {
        return this.bedrockAgentClient;
    }
}

