/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.bedrock.agent;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.aws2.bedrock.agent.BedrockAgentEndpoint;
import org.apache.camel.support.ScheduledPollConsumer;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.services.bedrockagent.BedrockAgentClient;
import software.amazon.awssdk.services.bedrockagent.model.GetIngestionJobRequest;
import software.amazon.awssdk.services.bedrockagent.model.GetIngestionJobResponse;

public class BedrockAgentIngestionJobConsumer
extends ScheduledPollConsumer {
    protected final BedrockAgentEndpoint endpoint;

    public BedrockAgentIngestionJobConsumer(BedrockAgentEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
    }

    protected int poll() throws Exception {
        GetIngestionJobRequest.Builder builder = GetIngestionJobRequest.builder();
        if (!ObjectHelper.isNotEmpty((String)this.getEndpoint().getConfiguration().getKnowledgeBaseId())) {
            throw new IllegalArgumentException("KnowledgeBaseId must be specified");
        }
        builder.knowledgeBaseId(this.getEndpoint().getConfiguration().getKnowledgeBaseId());
        if (!ObjectHelper.isNotEmpty((String)this.getEndpoint().getConfiguration().getDataSourceId())) {
            throw new IllegalArgumentException("DataSourceId must be specified");
        }
        builder.dataSourceId(this.getEndpoint().getConfiguration().getDataSourceId());
        if (!ObjectHelper.isNotEmpty((String)this.getEndpoint().getConfiguration().getIngestionJobId())) {
            throw new IllegalArgumentException("IngestionJobId must be specified");
        }
        builder.ingestionJobId(this.getEndpoint().getConfiguration().getIngestionJobId());
        GetIngestionJobResponse response = this.getClient().getIngestionJob((GetIngestionJobRequest)builder.build());
        this.getProcessor().process(this.createExchange(response));
        return 1;
    }

    private BedrockAgentClient getClient() {
        return this.getEndpoint().getBedrockAgentClient();
    }

    public BedrockAgentEndpoint getEndpoint() {
        return (BedrockAgentEndpoint)super.getEndpoint();
    }

    protected Exchange createExchange(GetIngestionJobResponse response) {
        Exchange exchange = this.createExchange(true);
        exchange.getMessage().setBody((Object)response.ingestionJob());
        exchange.getMessage().setHeader("CamelAwsBedrockAgentIngestionJobStatus", (Object)response.ingestionJob().status());
        return exchange;
    }
}

