/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.bedrock.agentruntime;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws2.bedrock.agentruntime.BedrockAgentRuntimeConfiguration;
import org.apache.camel.component.aws2.bedrock.agentruntime.BedrockAgentRuntimeEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.HealthCheckComponent;

@org.apache.camel.spi.annotations.Component(value="aws-bedrock-agent-runtime")
public class BedrockAgentRuntimeComponent
extends HealthCheckComponent {
    @Metadata
    private BedrockAgentRuntimeConfiguration configuration = new BedrockAgentRuntimeConfiguration();

    public BedrockAgentRuntimeComponent() {
        this(null);
    }

    public BedrockAgentRuntimeComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        BedrockAgentRuntimeConfiguration configuration = this.configuration != null ? this.configuration.copy() : new BedrockAgentRuntimeConfiguration();
        BedrockAgentRuntimeEndpoint endpoint = new BedrockAgentRuntimeEndpoint(uri, (Component)this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        if (Boolean.FALSE.equals(configuration.isUseDefaultCredentialsProvider()) && Boolean.FALSE.equals(configuration.isUseProfileCredentialsProvider()) && Boolean.FALSE.equals(configuration.isUseSessionCredentials()) && configuration.getBedrockAgentRuntimeClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("useDefaultCredentialsProvider is set to false, useProfileCredentialsProvider is set to false, useSessionCredentials is set to false, Amazon Bedrock runtime client or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public BedrockAgentRuntimeConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(BedrockAgentRuntimeConfiguration configuration) {
        this.configuration = configuration;
    }
}

