/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.cloudtrail;

import java.util.Map;
import org.apache.camel.component.aws.cloudtrail.CloudtrailConfiguration;
import org.apache.camel.component.aws.cloudtrail.CloudtrailConsumer;
import org.apache.camel.health.HealthCheckResultBuilder;
import org.apache.camel.impl.health.AbstractHealthCheck;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudtrail.CloudTrailClient;
import software.amazon.awssdk.services.cloudtrail.model.ListChannelsRequest;

public class CloudtrailConsumerHealthCheck
extends AbstractHealthCheck {
    private final CloudtrailConsumer cloudtrailConsumer;

    public CloudtrailConsumerHealthCheck(CloudtrailConsumer cloudtrailConsumer, String routeId) {
        super("camel", "aws-cloudtrail-consumer-" + routeId);
        this.cloudtrailConsumer = cloudtrailConsumer;
    }

    public boolean isLiveness() {
        return false;
    }

    protected void doCall(HealthCheckResultBuilder builder, Map<String, Object> options) {
        CloudtrailConfiguration configuration = this.cloudtrailConsumer.getEndpoint().getConfiguration();
        try {
            if (ObjectHelper.isNotEmpty((String)configuration.getRegion()) && !CloudTrailClient.serviceMetadata().regions().contains(Region.of((String)configuration.getRegion()))) {
                builder.message("The service is not supported in this region");
                builder.down();
                return;
            }
            CloudTrailClient client = this.cloudtrailConsumer.getEndpoint().getClient();
            client.listChannels((ListChannelsRequest)ListChannelsRequest.builder().maxResults(Integer.valueOf(1)).build());
        }
        catch (AwsServiceException e) {
            builder.message(e.getMessage());
            builder.error((Throwable)e);
            if (ObjectHelper.isNotEmpty((Object)e.statusCode())) {
                builder.detail("service.status.code", (Object)e.statusCode());
            }
            if (ObjectHelper.isNotEmpty((String)e.awsErrorDetails().errorCode())) {
                builder.detail("service.error.code", (Object)e.awsErrorDetails().errorCode());
            }
            builder.down();
            return;
        }
        catch (Exception e) {
            builder.error((Throwable)e);
            builder.down();
            return;
        }
        builder.up();
    }
}

