/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.cloudtrail;

import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.aws.cloudtrail.CloudtrailEndpoint;
import org.apache.camel.support.ScheduledBatchPollingConsumer;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.cloudtrail.CloudTrailClient;
import software.amazon.awssdk.services.cloudtrail.model.Event;
import software.amazon.awssdk.services.cloudtrail.model.LookupAttribute;
import software.amazon.awssdk.services.cloudtrail.model.LookupAttributeKey;
import software.amazon.awssdk.services.cloudtrail.model.LookupEventsRequest;
import software.amazon.awssdk.services.cloudtrail.model.LookupEventsResponse;

public class CloudtrailConsumer
extends ScheduledBatchPollingConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(CloudtrailConsumer.class);
    private static Instant lastTime;

    public CloudtrailConsumer(CloudtrailEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
    }

    protected void doStart() throws Exception {
        super.doStart();
    }

    protected int poll() throws Exception {
        LookupEventsResponse response;
        LookupEventsRequest.Builder eventsRequestBuilder = LookupEventsRequest.builder().maxResults(Integer.valueOf(this.getEndpoint().getConfiguration().getMaxResults()));
        ArrayList<LookupAttribute> attributes = new ArrayList<LookupAttribute>();
        if (ObjectHelper.isNotEmpty((String)this.getEndpoint().getConfiguration().getEventSource())) {
            LookupAttribute eventSource = (LookupAttribute)LookupAttribute.builder().attributeKey(LookupAttributeKey.EVENT_SOURCE).attributeValue(this.getEndpoint().getConfiguration().getEventSource()).build();
            attributes.add(eventSource);
        }
        if (!attributes.isEmpty()) {
            eventsRequestBuilder.lookupAttributes(attributes);
        }
        if (lastTime != null) {
            eventsRequestBuilder.startTime(lastTime.plusMillis(1000L));
        }
        if ((response = this.getClient().lookupEvents((LookupEventsRequest)eventsRequestBuilder.build())).events().size() > 0) {
            lastTime = ((Event)response.events().get(0)).eventTime();
        }
        Queue<Exchange> exchanges = this.createExchanges(response.events());
        int processedExchangeCount = this.processBatch(CastUtils.cast(exchanges));
        return processedExchangeCount;
    }

    public int processBatch(Queue<Object> exchanges) throws Exception {
        int processedExchanges = 0;
        while (!exchanges.isEmpty()) {
            Exchange exchange = (Exchange)ObjectHelper.cast(Exchange.class, (Object)exchanges.poll());
            AsyncCallback cb = this.defaultConsumerCallback(exchange, true);
            this.getAsyncProcessor().process(exchange, cb);
            ++processedExchanges;
        }
        return processedExchanges;
    }

    protected void doStop() throws Exception {
        super.doStop();
    }

    private CloudTrailClient getClient() {
        return this.getEndpoint().getClient();
    }

    public CloudtrailEndpoint getEndpoint() {
        return (CloudtrailEndpoint)super.getEndpoint();
    }

    private Queue<Exchange> createExchanges(List<Event> events) {
        ArrayDeque<Exchange> exchanges = new ArrayDeque<Exchange>();
        for (Event event : events) {
            exchanges.add(this.createExchange(event));
        }
        return exchanges;
    }

    protected Exchange createExchange(Event event) {
        Exchange exchange = this.createExchange(true);
        exchange.getIn().setBody((Object)event.cloudTrailEvent().getBytes(StandardCharsets.UTF_8));
        return exchange;
    }
}

