/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.cloudtrail.client;

import org.apache.camel.component.aws.cloudtrail.CloudtrailConfiguration;
import org.apache.camel.component.aws.cloudtrail.client.CloudtrailInternalClient;
import org.apache.camel.component.aws.cloudtrail.client.impl.CloudtrailClientIAMOptimizedImpl;
import org.apache.camel.component.aws.cloudtrail.client.impl.CloudtrailClientIAMProfileOptimizedImpl;
import org.apache.camel.component.aws.cloudtrail.client.impl.CloudtrailClientSessionTokenImpl;
import org.apache.camel.component.aws.cloudtrail.client.impl.CloudtrailClientStandardImpl;

public final class CloudtrailClientFactory {
    private CloudtrailClientFactory() {
    }

    public static CloudtrailInternalClient getCloudtrailClient(CloudtrailConfiguration configuration) {
        if (Boolean.TRUE.equals(configuration.isUseDefaultCredentialsProvider())) {
            return new CloudtrailClientIAMOptimizedImpl(configuration);
        }
        if (Boolean.TRUE.equals(configuration.isUseProfileCredentialsProvider())) {
            return new CloudtrailClientIAMProfileOptimizedImpl(configuration);
        }
        if (Boolean.TRUE.equals(configuration.isUseSessionCredentials())) {
            return new CloudtrailClientSessionTokenImpl(configuration);
        }
        return new CloudtrailClientStandardImpl(configuration);
    }
}

