/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.cloudtrail.transform;

import java.util.Map;
import org.apache.camel.Message;
import org.apache.camel.component.cloudevents.CloudEvents;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeTransformer;
import org.apache.camel.spi.Transformer;

@DataTypeTransformer(name="aws-cloudtrail:application-cloudevents", description="Adds CloudEvent headers to the Camel message with AWS Cloudtrail lookup events response details")
public class CloudtrailCloudEventDataTypeTransformer
extends Transformer {
    public void transform(Message message, DataType fromType, DataType toType) {
        Map headers = message.getHeaders();
        CloudEvents cloudEvent = CloudEvents.v1_0;
        headers.putIfAbsent("CamelCloudEventID", message.getExchange().getExchangeId());
        headers.putIfAbsent("CamelCloudEventVersion", cloudEvent.version());
        headers.put("CamelCloudEventType", "org.apache.camel.event.aws.cloudtrail.lookupEvents");
        if (message.getHeaders().containsKey("CamelAwsCloudTrailEventSource")) {
            headers.put("CamelCloudEventSource", "aws.cloudtrail.event.source." + (String)message.getHeader("CamelAwsCloudTrailEventSource", String.class));
        }
        headers.put("CamelCloudEventSubject", message.getHeader("CamelAwsCloudTrailEventId", String.class));
        headers.put("CamelCloudEventTime", cloudEvent.getEventTime(message.getExchange()));
        headers.put("Content-Type", "text/plain");
    }
}

