/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.cloudtrail;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws.cloudtrail.CloudtrailComponent;
import org.apache.camel.component.aws.cloudtrail.CloudtrailConfiguration;
import org.apache.camel.component.aws.cloudtrail.CloudtrailConstants;
import org.apache.camel.component.aws.cloudtrail.CloudtrailConsumer;
import org.apache.camel.component.aws.cloudtrail.client.CloudtrailClientFactory;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.services.cloudtrail.CloudTrailClient;

@UriEndpoint(firstVersion="3.19.0", scheme="aws-cloudtrail", title="AWS Cloudtrail", syntax="aws-cloudtrail:label", consumerOnly=true, category={Category.CLOUD, Category.MANAGEMENT, Category.MONITORING}, headersClass=CloudtrailConstants.class)
public class CloudtrailEndpoint
extends ScheduledPollEndpoint {
    @UriParam
    private CloudtrailConfiguration configuration;
    private CloudTrailClient cloudTrailClient;

    public CloudtrailEndpoint(String uri, CloudtrailConfiguration configuration, CloudtrailComponent component) {
        super(uri, (Component)component);
        this.configuration = configuration;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.cloudTrailClient = this.configuration.getCloudTrailClient() != null ? this.configuration.getCloudTrailClient() : CloudtrailClientFactory.getCloudtrailClient(this.configuration).getCloudtrailClient();
    }

    public void doStop() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.configuration.getCloudTrailClient()) && this.cloudTrailClient != null) {
            this.cloudTrailClient.close();
        }
        super.doStop();
    }

    public Producer createProducer() throws Exception {
        throw new UnsupportedOperationException("You cannot produce messages to this endpoint");
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        CloudtrailConsumer consumer = new CloudtrailConsumer(this, processor);
        consumer.setSchedulerProperties(this.getSchedulerProperties());
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public CloudtrailComponent getComponent() {
        return (CloudtrailComponent)super.getComponent();
    }

    public CloudTrailClient getClient() {
        return this.cloudTrailClient;
    }

    public CloudtrailConfiguration getConfiguration() {
        return this.configuration;
    }
}

