/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.config;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws.config.AWSConfigComponent;
import org.apache.camel.component.aws.config.AWSConfigConfiguration;
import org.apache.camel.component.aws.config.AWSConfigConstants;
import org.apache.camel.component.aws.config.AWSConfigProducer;
import org.apache.camel.component.aws.config.client.AWSConfigClientFactory;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.services.config.ConfigClient;

@UriEndpoint(firstVersion="4.3.0", scheme="aws-config", title="AWS Config Service", syntax="aws-config:label", producerOnly=true, category={Category.CLOUD, Category.MANAGEMENT}, headersClass=AWSConfigConstants.class)
public class AWSConfigEndpoint
extends DefaultEndpoint {
    private ConfigClient configClient;
    @UriParam
    private AWSConfigConfiguration configuration;

    public AWSConfigEndpoint(String uri, Component component, AWSConfigConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public AWSConfigComponent getComponent() {
        return (AWSConfigComponent)super.getComponent();
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public Producer createProducer() throws Exception {
        return new AWSConfigProducer((Endpoint)this);
    }

    public void doStart() throws Exception {
        super.doStart();
        this.configClient = this.configuration.getConfigClient() != null ? this.configuration.getConfigClient() : AWSConfigClientFactory.getConfigClient(this.configuration).getConfigClient();
    }

    public void doStop() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.configuration.getConfigClient()) && this.configClient != null) {
            this.configClient.close();
        }
        super.doStop();
    }

    public AWSConfigConfiguration getConfiguration() {
        return this.configuration;
    }

    public ConfigClient getConfigClient() {
        return this.configClient;
    }
}

