/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.secretsmanager;

import org.apache.camel.CamelContext;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws.secretsmanager.SecretsManagerClientHealthCheck;
import org.apache.camel.component.aws.secretsmanager.SecretsManagerConfiguration;
import org.apache.camel.component.aws.secretsmanager.SecretsManagerConstants;
import org.apache.camel.component.aws.secretsmanager.SecretsManagerProducer;
import org.apache.camel.component.aws.secretsmanager.client.SecretsManagerClientFactory;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckHelper;
import org.apache.camel.impl.health.ComponentsHealthCheckRepository;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;

@UriEndpoint(firstVersion="3.9.0", scheme="aws-secrets-manager", title="AWS Secrets Manager", syntax="aws-secrets-manager:label", producerOnly=true, category={Category.CLOUD, Category.MANAGEMENT}, headersClass=SecretsManagerConstants.class)
public class SecretsManagerEndpoint
extends ScheduledPollEndpoint {
    private SecretsManagerClient secretsManagerClient;
    private ComponentsHealthCheckRepository healthCheckRepository;
    private SecretsManagerClientHealthCheck clientHealthCheck;
    @UriParam
    private SecretsManagerConfiguration configuration;

    public SecretsManagerEndpoint(String uri, Component component, SecretsManagerConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public Producer createProducer() throws Exception {
        return new SecretsManagerProducer((Endpoint)this);
    }

    public void doStart() throws Exception {
        super.doStart();
        this.secretsManagerClient = this.configuration.getSecretsManagerClient() != null ? this.configuration.getSecretsManagerClient() : SecretsManagerClientFactory.getSecretsManagerClient(this.configuration).getSecretsManagerClient();
        this.healthCheckRepository = (ComponentsHealthCheckRepository)HealthCheckHelper.getHealthCheckRepository((CamelContext)this.getCamelContext(), (String)"components", ComponentsHealthCheckRepository.class);
        if (this.healthCheckRepository != null) {
            this.clientHealthCheck = new SecretsManagerClientHealthCheck(this, this.getId());
            this.healthCheckRepository.addHealthCheck((HealthCheck)this.clientHealthCheck);
        }
    }

    public void doStop() throws Exception {
        if (this.healthCheckRepository != null && this.clientHealthCheck != null) {
            this.healthCheckRepository.removeHealthCheck((HealthCheck)this.clientHealthCheck);
            this.clientHealthCheck = null;
        }
        if (ObjectHelper.isEmpty((Object)this.configuration.getSecretsManagerClient()) && this.secretsManagerClient != null) {
            this.secretsManagerClient.close();
        }
        super.doStop();
    }

    public SecretsManagerConfiguration getConfiguration() {
        return this.configuration;
    }

    public SecretsManagerClient getSecretsManagerClient() {
        return this.secretsManagerClient;
    }
}

