/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.aws.kinesis.springboot;

import javax.annotation.Generated;
import com.amazonaws.services.kinesis.AmazonKinesis;
import com.amazonaws.services.kinesis.model.ShardIteratorType;
import org.apache.camel.component.aws.kinesis.KinesisComponent;
import org.apache.camel.component.aws.kinesis.KinesisShardClosedStrategyEnum;
import org.apache.camel.spring.boot.ComponentConfigurationPropertiesCommon;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * The aws-kinesis component is for consuming and producing records from Amazon
 * Kinesis Streams.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.SpringBootAutoConfigurationMojo")
@ConfigurationProperties(prefix = "camel.component.aws-kinesis")
public class KinesisComponentConfiguration
        extends
            ComponentConfigurationPropertiesCommon {

    /**
     * Whether to enable auto configuration of the aws-kinesis component. This
     * is enabled by default.
     */
    private Boolean enabled;
    /**
     * The AWS S3 default configuration
     */
    private KinesisConfigurationNestedConfiguration configuration;
    /**
     * Amazon AWS Access Key
     */
    private String accessKey;
    /**
     * Amazon AWS Secret Key
     */
    private String secretKey;
    /**
     * Amazon AWS Region
     */
    private String region;
    /**
     * Whether the component should resolve property placeholders on itself when
     * starting. Only properties which are of String type can use property
     * placeholders.
     */
    private Boolean resolvePropertyPlaceholders = true;

    public KinesisConfigurationNestedConfiguration getConfiguration() {
        return configuration;
    }

    public void setConfiguration(
            KinesisConfigurationNestedConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getAccessKey() {
        return accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public Boolean getResolvePropertyPlaceholders() {
        return resolvePropertyPlaceholders;
    }

    public void setResolvePropertyPlaceholders(
            Boolean resolvePropertyPlaceholders) {
        this.resolvePropertyPlaceholders = resolvePropertyPlaceholders;
    }

    public static class KinesisConfigurationNestedConfiguration {
        public static final Class CAMEL_NESTED_CLASS = org.apache.camel.component.aws.kinesis.KinesisConfiguration.class;
        /**
         * Amazon Kinesis client to use for all requests for this endpoint
         */
        private AmazonKinesis amazonKinesisClient;
        /**
         * Maximum number of records that will be fetched in each poll
         */
        private Integer maxResultsPerRequest = 1;
        /**
         * Name of the stream
         */
        private String streamName;
        /**
         * Defines where in the Kinesis stream to start getting records
         */
        private ShardIteratorType iteratorType = ShardIteratorType.TRIM_HORIZON;
        /**
         * Defines which shardId in the Kinesis stream to get records from
         */
        private String shardId;
        /**
         * The sequence number to start polling from. Required if iteratorType
         * is set to AFTER_SEQUENCE_NUMBER or AT_SEQUENCE_NUMBER
         */
        private String sequenceNumber;
        /**
         * Define what will be the behavior in case of shard closed. Possible
         * value are ignore, silent and fail.In case of ignore a message will be
         * logged and the consumer will restart from the beginning,in case of
         * silent there will be no logging and the consumer will start from the
         * beginning,in case of fail a ReachedClosedStateException will be
         * raised
         */
        private KinesisShardClosedStrategyEnum shardClosed = KinesisShardClosedStrategyEnum.ignore;
        /**
         * Amazon AWS Access Key
         */
        private String accessKey;
        /**
         * Amazon AWS Secret Key
         */
        private String secretKey;
        /**
         * The region in which Kinesis client needs to work
         */
        private String region;
        /**
         * To define a proxy host when instantiating the DDBStreams client
         */
        private String proxyHost;
        /**
         * To define a proxy port when instantiating the DDBStreams client
         */
        private Integer proxyPort;

        public AmazonKinesis getAmazonKinesisClient() {
            return amazonKinesisClient;
        }

        public void setAmazonKinesisClient(AmazonKinesis amazonKinesisClient) {
            this.amazonKinesisClient = amazonKinesisClient;
        }

        public Integer getMaxResultsPerRequest() {
            return maxResultsPerRequest;
        }

        public void setMaxResultsPerRequest(Integer maxResultsPerRequest) {
            this.maxResultsPerRequest = maxResultsPerRequest;
        }

        public String getStreamName() {
            return streamName;
        }

        public void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public ShardIteratorType getIteratorType() {
            return iteratorType;
        }

        public void setIteratorType(ShardIteratorType iteratorType) {
            this.iteratorType = iteratorType;
        }

        public String getShardId() {
            return shardId;
        }

        public void setShardId(String shardId) {
            this.shardId = shardId;
        }

        public String getSequenceNumber() {
            return sequenceNumber;
        }

        public void setSequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }

        public KinesisShardClosedStrategyEnum getShardClosed() {
            return shardClosed;
        }

        public void setShardClosed(KinesisShardClosedStrategyEnum shardClosed) {
            this.shardClosed = shardClosed;
        }

        public String getAccessKey() {
            return accessKey;
        }

        public void setAccessKey(String accessKey) {
            this.accessKey = accessKey;
        }

        public String getSecretKey() {
            return secretKey;
        }

        public void setSecretKey(String secretKey) {
            this.secretKey = secretKey;
        }

        public String getRegion() {
            return region;
        }

        public void setRegion(String region) {
            this.region = region;
        }

        public String getProxyHost() {
            return proxyHost;
        }

        public void setProxyHost(String proxyHost) {
            this.proxyHost = proxyHost;
        }

        public Integer getProxyPort() {
            return proxyPort;
        }

        public void setProxyPort(Integer proxyPort) {
            this.proxyPort = proxyPort;
        }
    }
}