/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.xray.decorators;

import com.amazonaws.xray.entities.Entity;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.aws.xray.decorators.AbstractSegmentDecorator;

public class SqlSegmentDecorator
extends AbstractSegmentDecorator {
    public static final String CAMEL_SQL_QUERY = "CamelSqlQuery";

    @Override
    public String getComponent() {
        return "sql";
    }

    @Override
    public void pre(Entity segment, Exchange exchange, Endpoint endpoint) {
        super.pre(segment, exchange, endpoint);
        segment.putMetadata("db.type", (Object)"sql");
        Object sqlQuery = exchange.getIn().getHeader(CAMEL_SQL_QUERY);
        if (sqlQuery instanceof String) {
            segment.putSql("db.statement", sqlQuery);
        }
    }
}

