/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.ddb;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClient;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeTableRequest;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.ResourceNotFoundException;
import com.amazonaws.services.dynamodbv2.model.TableDescription;
import com.amazonaws.services.dynamodbv2.model.TableStatus;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws.ddb.DdbConfiguration;
import org.apache.camel.component.aws.ddb.DdbProducer;
import org.apache.camel.impl.ScheduledPollEndpoint;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(scheme="aws-ddb", title="AWS DynamoDB", syntax="aws-ddb:tableName", producerOnly=true, label="cloud,database,nosql")
public class DdbEndpoint
extends ScheduledPollEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(DdbEndpoint.class);
    @UriParam
    private DdbConfiguration configuration;
    private AmazonDynamoDB ddbClient;

    @Deprecated
    public DdbEndpoint(String uri, CamelContext context, DdbConfiguration configuration) {
        super(uri, context);
        this.configuration = configuration;
    }

    public DdbEndpoint(String uri, Component component, DdbConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public Producer createProducer() throws Exception {
        return new DdbProducer((Endpoint)this);
    }

    public boolean isSingleton() {
        return true;
    }

    public void doStart() throws Exception {
        super.doStart();
        AmazonDynamoDB amazonDynamoDB = this.ddbClient = this.configuration.getAmazonDDBClient() != null ? this.configuration.getAmazonDDBClient() : this.createDdbClient();
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getAmazonDdbEndpoint())) {
            this.ddbClient.setEndpoint(this.configuration.getAmazonDdbEndpoint());
        }
        String tableName = this.getConfiguration().getTableName();
        LOG.trace("Querying whether table [{}] already exists...", (Object)tableName);
        try {
            DescribeTableRequest request = new DescribeTableRequest().withTableName(tableName);
            TableDescription tableDescription = this.ddbClient.describeTable(request).getTable();
            if (!this.isTableActive(tableDescription)) {
                this.waitForTableToBecomeAvailable(tableName);
            }
            LOG.trace("Table [{}] already exists", (Object)tableName);
            return;
        }
        catch (ResourceNotFoundException e) {
            LOG.trace("Table [{}] doesn't exist yet", (Object)tableName);
            LOG.trace("Creating table [{}]...", (Object)tableName);
            TableDescription tableDescription = this.createTable(tableName);
            if (!this.isTableActive(tableDescription)) {
                this.waitForTableToBecomeAvailable(tableName);
            }
            LOG.trace("Table [{}] created", (Object)tableName);
            return;
        }
    }

    private TableDescription createTable(String tableName) {
        CreateTableRequest createTableRequest = new CreateTableRequest().withTableName(tableName).withKeySchema(new KeySchemaElement[]{new KeySchemaElement().withAttributeName(this.configuration.getKeyAttributeName()).withKeyType(this.configuration.getKeyAttributeType())}).withProvisionedThroughput(new ProvisionedThroughput().withReadCapacityUnits(this.configuration.getReadCapacity()).withWriteCapacityUnits(this.configuration.getWriteCapacity()));
        return this.getDdbClient().createTable(createTableRequest).getTableDescription();
    }

    public DdbConfiguration getConfiguration() {
        return this.configuration;
    }

    public AmazonDynamoDB getDdbClient() {
        return this.ddbClient;
    }

    AmazonDynamoDB createDdbClient() {
        AmazonDynamoDBClient client = null;
        BasicAWSCredentials credentials = new BasicAWSCredentials(this.configuration.getAccessKey(), this.configuration.getSecretKey());
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getProxyHost()) && ObjectHelper.isNotEmpty((Object)this.configuration.getProxyPort())) {
            ClientConfiguration clientConfiguration = new ClientConfiguration();
            clientConfiguration.setProxyHost(this.configuration.getProxyHost());
            clientConfiguration.setProxyPort(this.configuration.getProxyPort().intValue());
            client = new AmazonDynamoDBClient((AWSCredentials)credentials, clientConfiguration);
        } else {
            client = new AmazonDynamoDBClient((AWSCredentials)credentials);
        }
        return client;
    }

    private void waitForTableToBecomeAvailable(String tableName) {
        LOG.trace("Waiting for [{}] to become ACTIVE...", (Object)tableName);
        long waitTime = 300000L;
        while (waitTime > 0L) {
            try {
                Thread.sleep(5000L);
                waitTime -= 5000L;
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                DescribeTableRequest request = new DescribeTableRequest().withTableName(tableName);
                TableDescription tableDescription = this.getDdbClient().describeTable(request).getTable();
                if (this.isTableActive(tableDescription)) {
                    LOG.trace("Table [{}] became active", (Object)tableName);
                    return;
                }
                LOG.trace("Table [{}] not active yet", (Object)tableName);
            }
            catch (AmazonServiceException ase) {
                if (ase.getErrorCode().equalsIgnoreCase("ResourceNotFoundException")) continue;
                throw ase;
            }
        }
        throw new RuntimeException("Table " + tableName + " never went active");
    }

    private boolean isTableActive(TableDescription tableDescription) {
        return tableDescription.getTableStatus().equals(TableStatus.ACTIVE.toString());
    }
}

