/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.sqs;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws.sqs.SqsConfiguration;
import org.apache.camel.component.aws.sqs.SqsEndpoint;
import org.apache.camel.impl.UriEndpointComponent;

public class SqsComponent
extends UriEndpointComponent {
    public SqsComponent() {
        super(SqsEndpoint.class);
    }

    public SqsComponent(CamelContext context) {
        super(context, SqsEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        SqsConfiguration configuration = new SqsConfiguration();
        this.setProperties(configuration, parameters);
        if (remaining == null || remaining.trim().length() == 0) {
            throw new IllegalArgumentException("Queue name must be specified.");
        }
        configuration.setQueueName(remaining);
        if (configuration.getAmazonSQSClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("AmazonSQSClient or accessKey and secretKey must be specified.");
        }
        if (configuration.isExtendMessageVisibility() && configuration.getVisibilityTimeout() == null) {
            throw new IllegalArgumentException("Extending message visibility (extendMessageVisibility) requires visibilityTimeout to be set on the Endpoint.");
        }
        SqsEndpoint sqsEndpoint = new SqsEndpoint(uri, this, configuration);
        sqsEndpoint.setConsumerProperties(parameters);
        return sqsEndpoint;
    }
}

