/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.ddb;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.model.DeleteTableRequest;
import com.amazonaws.services.dynamodbv2.model.TableDescription;
import java.util.HashMap;
import org.apache.camel.Exchange;
import org.apache.camel.component.aws.ddb.AbstractDdbCommand;
import org.apache.camel.component.aws.ddb.DdbConfiguration;

public class DeleteTableCommand
extends AbstractDdbCommand {
    public DeleteTableCommand(AmazonDynamoDB ddbClient, DdbConfiguration configuration, Exchange exchange) {
        super(ddbClient, configuration, exchange);
    }

    @Override
    public void execute() {
        TableDescription tableDescription = this.ddbClient.deleteTable(new DeleteTableRequest(this.determineTableName())).getTableDescription();
        HashMap<String, Object> tmp = new HashMap<String, Object>();
        tmp.put("CamelAwsDdbProvisionedThroughput", tableDescription.getProvisionedThroughput());
        tmp.put("CamelAwsDdbCreationDate", tableDescription.getCreationDateTime());
        tmp.put("CamelAwsDdbTableItemCount", tableDescription.getItemCount());
        tmp.put("CamelAwsDdbKeySchema", tableDescription.getKeySchema());
        tmp.put("CamelAwsDdbTableName", tableDescription.getTableName());
        tmp.put("CamelAwsDdbTableSize", tableDescription.getTableSizeBytes());
        tmp.put("CamelAwsDdbTableStatus", tableDescription.getTableStatus());
        this.addToResults(tmp);
    }
}

