/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.sdb;

import com.amazonaws.services.simpledb.AmazonSimpleDB;
import com.amazonaws.services.simpledb.model.PutAttributesRequest;
import com.amazonaws.services.simpledb.model.ReplaceableAttribute;
import java.util.Collection;
import org.apache.camel.Exchange;
import org.apache.camel.component.aws.sdb.AbstractSdbCommand;
import org.apache.camel.component.aws.sdb.SdbConfiguration;

public class PutAttributesCommand
extends AbstractSdbCommand {
    public PutAttributesCommand(AmazonSimpleDB sdbClient, SdbConfiguration configuration, Exchange exchange) {
        super(sdbClient, configuration, exchange);
    }

    @Override
    public void execute() {
        PutAttributesRequest request = new PutAttributesRequest().withDomainName(this.determineDomainName()).withItemName(this.determineItemName()).withAttributes(this.determineReplaceableAttributes()).withExpected(this.determineUpdateCondition());
        this.log.trace("Sending request [{}] for exchange [{}]...", (Object)request, (Object)this.exchange);
        this.sdbClient.putAttributes(request);
        this.log.trace("Request sent");
    }

    protected Collection<ReplaceableAttribute> determineReplaceableAttributes() {
        return (Collection)this.exchange.getIn().getHeader("CamelAwsSdbReplaceableAttributes", Collection.class);
    }
}

