/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.athena;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws2.athena.Athena2Configuration;
import org.apache.camel.component.aws2.athena.Athena2Endpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@org.apache.camel.spi.annotations.Component(value="aws2-athena")
public class Athena2Component
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(Athena2Component.class);
    @Metadata
    private Athena2Configuration configuration = new Athena2Configuration();

    public Athena2Component() {
        this(null);
    }

    public Athena2Component(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        Athena2Configuration configurationClone = this.configuration != null ? this.configuration.copy() : new Athena2Configuration();
        Athena2Endpoint endpoint = new Athena2Endpoint(uri, (Component)this, configurationClone);
        this.setProperties((Endpoint)endpoint, parameters);
        if (!(configurationClone.isUseDefaultCredentialsProvider().booleanValue() || configurationClone.getAmazonAthenaClient() != null || configurationClone.getAccessKey() != null && configurationClone.getSecretKey() != null)) {
            throw new IllegalArgumentException("useDefaultCredentialsProvider is set to false, accessKey/secretKey or amazonAthenaClient must be specified");
        }
        return endpoint;
    }

    public Athena2Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Athena2Configuration configuration) {
        this.configuration = configuration;
    }
}

