/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.ddbstream;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.dynamodb.model.Shard;

class ShardTree {
    private final Map<String, Shard> shards = new HashMap<String, Shard>();

    ShardTree() {
    }

    void populate(Collection<Shard> shards) {
        this.shards.clear();
        for (Shard shard : shards) {
            this.shards.put(shard.shardId(), shard);
        }
    }

    List<Shard> getRoots() {
        List<Shard> roots = this.shards.values().stream().filter(s -> !this.shards.containsKey(s.parentShardId())).collect(Collectors.toList());
        if (roots.isEmpty()) {
            throw new IllegalStateException("Unable to find an unparented shard in " + this.shards);
        }
        return roots;
    }

    List<Shard> getLeaves() {
        return this.shards.values().stream().filter(s -> s.sequenceNumberRange().endingSequenceNumber() == null).collect(Collectors.toList());
    }

    List<Shard> getChildren(String shardId) {
        return this.shards.values().stream().filter(s -> shardId.equals(s.parentShardId())).collect(Collectors.toList());
    }

    public String toString() {
        return "ShardList{shards=" + this.shards + "}";
    }
}

