/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.ddbstream;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Processor;
import org.apache.camel.component.aws2.ddbstream.Ddb2StreamEndpoint;
import org.apache.camel.component.aws2.ddbstream.ShardIteratorHandler;
import org.apache.camel.support.ScheduledBatchPollingConsumer;
import org.apache.camel.util.CastUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.dynamodb.model.ExpiredIteratorException;
import software.amazon.awssdk.services.dynamodb.model.GetRecordsRequest;
import software.amazon.awssdk.services.dynamodb.model.GetRecordsResponse;
import software.amazon.awssdk.services.dynamodb.model.Record;

public class Ddb2StreamConsumer
extends ScheduledBatchPollingConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(Ddb2StreamConsumer.class);
    private final ShardIteratorHandler shardIteratorHandler;
    private final Map<String, String> lastSeenSequenceNumbers = new HashMap<String, String>();

    public Ddb2StreamConsumer(Ddb2StreamEndpoint endpoint, Processor processor) {
        this(endpoint, processor, new ShardIteratorHandler(endpoint));
    }

    Ddb2StreamConsumer(Ddb2StreamEndpoint endpoint, Processor processor, ShardIteratorHandler shardIteratorHandler) {
        super((Endpoint)endpoint, processor);
        this.shardIteratorHandler = shardIteratorHandler;
    }

    protected int poll() throws Exception {
        int processedExchangeCount = 0;
        Map<String, String> shardIterators = this.shardIteratorHandler.getShardIterators();
        for (Map.Entry<String, String> shardIteratorEntry : shardIterators.entrySet()) {
            GetRecordsResponse result;
            int limitPerRecordsRequest = Math.max(1, this.getEndpoint().getConfiguration().getMaxResultsPerRequest() / shardIterators.size());
            String shardId = shardIteratorEntry.getKey();
            String shardIterator = shardIteratorEntry.getValue();
            try {
                GetRecordsRequest req = (GetRecordsRequest)GetRecordsRequest.builder().shardIterator(shardIterator).limit(Integer.valueOf(limitPerRecordsRequest)).build();
                result = this.getEndpoint().getClient().getRecords(req);
            }
            catch (ExpiredIteratorException e) {
                String lastSeenSequenceNumber = this.lastSeenSequenceNumbers.get(shardId);
                LOG.warn("Expired Shard Iterator, attempting to resume from {}", (Object)lastSeenSequenceNumber, (Object)e);
                GetRecordsRequest req = (GetRecordsRequest)GetRecordsRequest.builder().shardIterator(this.shardIteratorHandler.requestFreshShardIterator(shardId, lastSeenSequenceNumber)).limit(Integer.valueOf(limitPerRecordsRequest)).build();
                result = this.getEndpoint().getClient().getRecords(req);
            }
            List records = result.records();
            ArrayDeque<Exchange> exchanges = new ArrayDeque<Exchange>();
            for (Record record : records) {
                exchanges.add(this.createExchange(record));
            }
            processedExchangeCount += this.processBatch(CastUtils.cast(exchanges));
            this.shardIteratorHandler.updateShardIterator(shardId, result.nextShardIterator());
            if (records.isEmpty()) continue;
            this.lastSeenSequenceNumbers.put(shardId, ((Record)records.get(records.size() - 1)).dynamodb().sequenceNumber());
        }
        return processedExchangeCount;
    }

    public int processBatch(Queue<Object> exchanges) throws Exception {
        int total = exchanges.size();
        int answer = 0;
        for (int index = 0; index < total && this.isBatchAllowed(); ++index) {
            Exchange exchange = (Exchange)exchanges.poll();
            exchange.setProperty(ExchangePropertyKey.BATCH_INDEX, (Object)index);
            exchange.setProperty(ExchangePropertyKey.BATCH_SIZE, (Object)total);
            exchange.setProperty(ExchangePropertyKey.BATCH_COMPLETE, (Object)(index == total - 1 ? 1 : 0));
            this.pendingExchanges = total - index - 1;
            AsyncCallback cb = this.defaultConsumerCallback(exchange, true);
            this.getAsyncProcessor().process(exchange, cb);
            ++answer;
        }
        return answer;
    }

    protected Exchange createExchange(Record record) {
        Exchange ex = this.createExchange(true);
        ex.getIn().setBody((Object)record, Record.class);
        return ex;
    }

    public Ddb2StreamEndpoint getEndpoint() {
        return (Ddb2StreamEndpoint)super.getEndpoint();
    }
}

