/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.ec2;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws2.ec2.AWS2EC2Configuration;
import org.apache.camel.component.aws2.ec2.AWS2EC2Producer;
import org.apache.camel.component.aws2.ec2.client.AWS2EC2ClientFactory;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.services.ec2.Ec2Client;

@UriEndpoint(firstVersion="3.1.0", scheme="aws2-ec2", title="AWS Elastic Compute Cloud (EC2)", syntax="aws2-ec2:label", producerOnly=true, category={Category.CLOUD, Category.MANAGEMENT})
public class AWS2EC2Endpoint
extends ScheduledPollEndpoint {
    private Ec2Client ec2Client;
    @UriParam
    private AWS2EC2Configuration configuration;

    public AWS2EC2Endpoint(String uri, Component component, AWS2EC2Configuration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public Producer createProducer() throws Exception {
        return new AWS2EC2Producer((Endpoint)this);
    }

    public void doStart() throws Exception {
        super.doStart();
        this.ec2Client = this.configuration.getAmazonEc2Client() != null ? this.configuration.getAmazonEc2Client() : AWS2EC2ClientFactory.getEc2Client(this.configuration).getEc2Client();
    }

    public void doStop() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.configuration.getAmazonEc2Client()) && this.ec2Client != null) {
            this.ec2Client.close();
        }
        super.doStop();
    }

    public AWS2EC2Configuration getConfiguration() {
        return this.configuration;
    }

    public Ec2Client getEc2Client() {
        return this.ec2Client;
    }
}

