/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.ec2;

import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.aws2.ec2.AWS2EC2Operations;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.ec2.Ec2Client;

@UriParams
public class AWS2EC2Configuration
implements Cloneable {
    @UriPath(description="Logical name")
    @Metadata(required=true)
    private String label;
    @UriParam(label="producer")
    @Metadata(autowired=true)
    private Ec2Client amazonEc2Client;
    @UriParam(label="producer", secret=true)
    private String accessKey;
    @UriParam(label="producer", secret=true)
    private String secretKey;
    @UriParam(label="producer")
    @Metadata(required=true)
    private AWS2EC2Operations operation;
    @UriParam(enums="HTTP,HTTPS", defaultValue="HTTPS")
    private Protocol proxyProtocol = Protocol.HTTPS;
    @UriParam(label="producer")
    private String proxyHost;
    @UriParam(label="producer")
    private Integer proxyPort;
    @UriParam
    private String region;
    @UriParam(defaultValue="false")
    private boolean pojoRequest;
    @UriParam(defaultValue="false")
    private boolean trustAllCertificates;
    @UriParam(defaultValue="false")
    private boolean overrideEndpoint;
    @UriParam
    private String uriEndpointOverride;
    @UriParam(defaultValue="false")
    private boolean useDefaultCredentialsProvider;

    public Ec2Client getAmazonEc2Client() {
        return this.amazonEc2Client;
    }

    public void setAmazonEc2Client(Ec2Client amazonEc2Client) {
        this.amazonEc2Client = amazonEc2Client;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public AWS2EC2Operations getOperation() {
        return this.operation;
    }

    public void setOperation(AWS2EC2Operations operation) {
        this.operation = operation;
    }

    public Protocol getProxyProtocol() {
        return this.proxyProtocol;
    }

    public void setProxyProtocol(Protocol proxyProtocol) {
        this.proxyProtocol = proxyProtocol;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public boolean isPojoRequest() {
        return this.pojoRequest;
    }

    public void setPojoRequest(boolean pojoRequest) {
        this.pojoRequest = pojoRequest;
    }

    public boolean isTrustAllCertificates() {
        return this.trustAllCertificates;
    }

    public void setTrustAllCertificates(boolean trustAllCertificates) {
        this.trustAllCertificates = trustAllCertificates;
    }

    public boolean isOverrideEndpoint() {
        return this.overrideEndpoint;
    }

    public void setOverrideEndpoint(boolean overrideEndpoint) {
        this.overrideEndpoint = overrideEndpoint;
    }

    public String getUriEndpointOverride() {
        return this.uriEndpointOverride;
    }

    public void setUriEndpointOverride(String uriEndpointOverride) {
        this.uriEndpointOverride = uriEndpointOverride;
    }

    public void setUseDefaultCredentialsProvider(Boolean useDefaultCredentialsProvider) {
        this.useDefaultCredentialsProvider = useDefaultCredentialsProvider;
    }

    public Boolean isUseDefaultCredentialsProvider() {
        return this.useDefaultCredentialsProvider;
    }

    public AWS2EC2Configuration copy() {
        try {
            return (AWS2EC2Configuration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }
}

