/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.eks;

import org.apache.camel.CamelContext;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws2.eks.EKS2ClientHealthCheck;
import org.apache.camel.component.aws2.eks.EKS2Configuration;
import org.apache.camel.component.aws2.eks.EKS2Constants;
import org.apache.camel.component.aws2.eks.EKS2Producer;
import org.apache.camel.component.aws2.eks.client.EKS2ClientFactory;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckHelper;
import org.apache.camel.impl.health.ComponentsHealthCheckRepository;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.services.eks.EksClient;

@UriEndpoint(firstVersion="3.1.0", scheme="aws2-eks", title="AWS Elastic Kubernetes Service (EKS)", syntax="aws2-eks:label", producerOnly=true, category={Category.CLOUD, Category.MANAGEMENT}, headersClass=EKS2Constants.class)
public class EKS2Endpoint
extends ScheduledPollEndpoint {
    private EksClient eksClient;
    private ComponentsHealthCheckRepository healthCheckRepository;
    private EKS2ClientHealthCheck clientHealthCheck;
    @UriParam
    private EKS2Configuration configuration;

    public EKS2Endpoint(String uri, Component component, EKS2Configuration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public Producer createProducer() throws Exception {
        return new EKS2Producer((Endpoint)this);
    }

    public void doStart() throws Exception {
        super.doStart();
        this.eksClient = this.configuration.getEksClient() != null ? this.configuration.getEksClient() : EKS2ClientFactory.getEksClient(this.configuration).getEksClient();
        this.healthCheckRepository = (ComponentsHealthCheckRepository)HealthCheckHelper.getHealthCheckRepository((CamelContext)this.getCamelContext(), (String)"components", ComponentsHealthCheckRepository.class);
        if (this.healthCheckRepository != null) {
            this.clientHealthCheck = new EKS2ClientHealthCheck(this, this.getId());
            this.healthCheckRepository.addHealthCheck((HealthCheck)this.clientHealthCheck);
        }
    }

    public void doStop() throws Exception {
        if (this.healthCheckRepository != null && this.clientHealthCheck != null) {
            this.healthCheckRepository.removeHealthCheck((HealthCheck)this.clientHealthCheck);
            this.clientHealthCheck = null;
        }
        if (ObjectHelper.isEmpty((Object)this.configuration.getEksClient()) && this.eksClient != null) {
            this.eksClient.close();
        }
        super.doStop();
    }

    public EKS2Configuration getConfiguration() {
        return this.configuration;
    }

    public EksClient getEksClient() {
        return this.eksClient;
    }
}

