/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.eks;

import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.component.aws2.eks.EKS2Configuration;
import org.apache.camel.component.aws2.eks.EKS2Endpoint;
import org.apache.camel.component.aws2.eks.EKS2Operations;
import org.apache.camel.component.aws2.eks.EKS2ProducerHealthCheck;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckHelper;
import org.apache.camel.health.WritableHealthCheckRepository;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.services.eks.EksClient;
import software.amazon.awssdk.services.eks.model.CreateClusterRequest;
import software.amazon.awssdk.services.eks.model.CreateClusterResponse;
import software.amazon.awssdk.services.eks.model.DeleteClusterRequest;
import software.amazon.awssdk.services.eks.model.DeleteClusterResponse;
import software.amazon.awssdk.services.eks.model.DescribeClusterRequest;
import software.amazon.awssdk.services.eks.model.DescribeClusterResponse;
import software.amazon.awssdk.services.eks.model.ListClustersRequest;
import software.amazon.awssdk.services.eks.model.ListClustersResponse;
import software.amazon.awssdk.services.eks.model.VpcConfigRequest;

public class EKS2Producer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(EKS2Producer.class);
    private transient String eksProducerToString;
    private HealthCheck producerHealthCheck;
    private WritableHealthCheckRepository healthCheckRepository;

    public EKS2Producer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        switch (this.determineOperation(exchange)) {
            case listClusters: {
                this.listClusters(this.getEndpoint().getEksClient(), exchange);
                break;
            }
            case describeCluster: {
                this.describeCluster(this.getEndpoint().getEksClient(), exchange);
                break;
            }
            case createCluster: {
                this.createCluster(this.getEndpoint().getEksClient(), exchange);
                break;
            }
            case deleteCluster: {
                this.deleteCluster(this.getEndpoint().getEksClient(), exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
    }

    private EKS2Operations determineOperation(Exchange exchange) {
        EKS2Operations operation = (EKS2Operations)((Object)exchange.getIn().getHeader("CamelAwsEKSOperation", EKS2Operations.class));
        if (operation == null) {
            operation = this.getConfiguration().getOperation();
        }
        return operation;
    }

    protected EKS2Configuration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public String toString() {
        if (this.eksProducerToString == null) {
            this.eksProducerToString = "EKSProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.eksProducerToString;
    }

    public EKS2Endpoint getEndpoint() {
        return (EKS2Endpoint)super.getEndpoint();
    }

    private void listClusters(EksClient eksClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof ListClustersRequest) {
                ListClustersResponse result;
                try {
                    result = eksClient.listClusters((ListClustersRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("List Clusters command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = EKS2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            ListClustersResponse result;
            ListClustersRequest.Builder builder = ListClustersRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEKSMaxResults"))) {
                int maxRes = (Integer)exchange.getIn().getHeader("CamelAwsEKSMaxResults", Integer.class);
                builder.maxResults(Integer.valueOf(maxRes));
            }
            try {
                result = eksClient.listClusters((ListClustersRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("List Clusters command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = EKS2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void createCluster(EksClient eksClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof CreateClusterRequest) {
                CreateClusterResponse result;
                try {
                    result = eksClient.createCluster((CreateClusterRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Create Cluster command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = EKS2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            CreateClusterResponse result;
            CreateClusterRequest.Builder builder = CreateClusterRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEKSClusterName"))) {
                String name = (String)exchange.getIn().getHeader("CamelAwsEKSClusterName", String.class);
                builder.name(name);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEKSRoleARN"))) {
                String roleArn = (String)exchange.getIn().getHeader("CamelAwsEKSRoleARN", String.class);
                builder.roleArn(roleArn);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEKSVPCConfig"))) {
                VpcConfigRequest vpcConfig = (VpcConfigRequest)exchange.getIn().getHeader("CamelAwsEKSVPCConfig", VpcConfigRequest.class);
                builder.resourcesVpcConfig(vpcConfig);
            }
            try {
                result = eksClient.createCluster((CreateClusterRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Create Cluster command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = EKS2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void describeCluster(EksClient eksClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof DescribeClusterRequest) {
                DescribeClusterResponse result;
                try {
                    result = eksClient.describeCluster((DescribeClusterRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Describe Cluster command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = EKS2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            DescribeClusterResponse result;
            DescribeClusterRequest.Builder builder = DescribeClusterRequest.builder();
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEKSClusterName"))) {
                throw new IllegalArgumentException("Cluster name must be specified");
            }
            String name = (String)exchange.getIn().getHeader("CamelAwsEKSClusterName", String.class);
            builder.name(name);
            try {
                result = eksClient.describeCluster((DescribeClusterRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Describe Cluster command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = EKS2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void deleteCluster(EksClient eksClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof DeleteClusterRequest) {
                DeleteClusterResponse result;
                try {
                    result = eksClient.deleteCluster((DeleteClusterRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Delete Cluster command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = EKS2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            DeleteClusterResponse result;
            DeleteClusterRequest.Builder builder = DeleteClusterRequest.builder();
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEKSClusterName"))) {
                throw new IllegalArgumentException("Cluster name must be specified");
            }
            String name = (String)exchange.getIn().getHeader("CamelAwsEKSClusterName", String.class);
            builder.name(name);
            try {
                result = eksClient.deleteCluster((DeleteClusterRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Delete Cluster command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = EKS2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    public static Message getMessageForResponse(Exchange exchange) {
        return exchange.getMessage();
    }

    protected void doStart() throws Exception {
        this.healthCheckRepository = (WritableHealthCheckRepository)HealthCheckHelper.getHealthCheckRepository((CamelContext)this.getEndpoint().getCamelContext(), (String)"producers", WritableHealthCheckRepository.class);
        if (this.healthCheckRepository != null) {
            String id = this.getEndpoint().getId();
            this.producerHealthCheck = new EKS2ProducerHealthCheck(this.getEndpoint(), id);
            this.producerHealthCheck.setEnabled(this.getEndpoint().getComponent().isHealthCheckProducerEnabled());
            this.healthCheckRepository.addHealthCheck(this.producerHealthCheck);
        }
    }

    protected void doStop() throws Exception {
        if (this.healthCheckRepository != null && this.producerHealthCheck != null) {
            this.healthCheckRepository.removeHealthCheck(this.producerHealthCheck);
            this.producerHealthCheck = null;
        }
    }
}

