/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.eventbridge;

import java.util.Map;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws2.eventbridge.EventbridgeComponent;
import org.apache.camel.component.aws2.eventbridge.EventbridgeConfiguration;
import org.apache.camel.component.aws2.eventbridge.EventbridgeConstants;
import org.apache.camel.component.aws2.eventbridge.EventbridgeProducer;
import org.apache.camel.component.aws2.eventbridge.client.EventbridgeClientFactory;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.services.eventbridge.EventBridgeClient;

@UriEndpoint(firstVersion="3.6.0", scheme="aws2-eventbridge", title="AWS Eventbridge", syntax="aws2-eventbridge://eventbusNameOrArn", producerOnly=true, category={Category.CLOUD, Category.MANAGEMENT}, headersClass=EventbridgeConstants.class)
public class EventbridgeEndpoint
extends DefaultEndpoint
implements EndpointServiceLocation {
    private EventBridgeClient eventbridgeClient;
    @UriPath(description="Event bus name or ARN")
    @Metadata(required=true)
    private String eventbusNameOrArn;
    @UriParam
    private EventbridgeConfiguration configuration;

    public EventbridgeEndpoint(String uri, Component component, EventbridgeConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public EventbridgeComponent getComponent() {
        return (EventbridgeComponent)super.getComponent();
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public Producer createProducer() throws Exception {
        return new EventbridgeProducer((Endpoint)this);
    }

    public void doStart() throws Exception {
        super.doStart();
        this.eventbridgeClient = this.configuration.getEventbridgeClient() != null ? this.configuration.getEventbridgeClient() : EventbridgeClientFactory.getEventbridgeClient(this.configuration).getEventbridgeClient();
    }

    public void doStop() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.configuration.getEventbridgeClient()) && this.eventbridgeClient != null) {
            this.eventbridgeClient.close();
        }
        super.doStop();
    }

    public EventbridgeConfiguration getConfiguration() {
        return this.configuration;
    }

    public EventBridgeClient getEventbridgeClient() {
        return this.eventbridgeClient;
    }

    public String getServiceUrl() {
        if (!this.configuration.isOverrideEndpoint()) {
            if (ObjectHelper.isNotEmpty((String)this.configuration.getRegion())) {
                return this.configuration.getRegion();
            }
        } else if (ObjectHelper.isNotEmpty((String)this.configuration.getUriEndpointOverride())) {
            return this.configuration.getUriEndpointOverride();
        }
        return null;
    }

    public String getServiceProtocol() {
        return "eventbridge";
    }

    public Map<String, String> getServiceMetadata() {
        if (this.configuration.getEventbusName() != null) {
            return Map.of("eventbus", this.configuration.getEventbusName());
        }
        return null;
    }
}

