/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.eventbridge;

import java.util.Map;
import org.apache.camel.component.aws2.eventbridge.EventbridgeConfiguration;
import org.apache.camel.component.aws2.eventbridge.EventbridgeEndpoint;
import org.apache.camel.health.HealthCheckResultBuilder;
import org.apache.camel.impl.health.AbstractHealthCheck;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.eventbridge.EventBridgeClient;
import software.amazon.awssdk.services.eventbridge.model.ListEventBusesRequest;

public class EventbridgeProducerHealthCheck
extends AbstractHealthCheck {
    private final EventbridgeEndpoint eventbridgeEndpoint;

    public EventbridgeProducerHealthCheck(EventbridgeEndpoint eventbridgeEndpoint, String clientId) {
        super("camel", "producer:aws2-eventbridge-" + clientId);
        this.eventbridgeEndpoint = eventbridgeEndpoint;
    }

    protected void doCall(HealthCheckResultBuilder builder, Map<String, Object> options) {
        EventbridgeConfiguration configuration = this.eventbridgeEndpoint.getConfiguration();
        if (ObjectHelper.isNotEmpty((String)configuration.getRegion()) && !EventBridgeClient.serviceMetadata().regions().contains(Region.of((String)configuration.getRegion()))) {
            builder.message("The service is not supported in this region");
            builder.down();
            return;
        }
        try {
            EventBridgeClient eventbridgeClient = this.eventbridgeEndpoint.getEventbridgeClient();
            eventbridgeClient.listEventBuses((ListEventBusesRequest)ListEventBusesRequest.builder().limit(Integer.valueOf(1)).build());
        }
        catch (AwsServiceException e) {
            builder.message(e.getMessage());
            builder.error((Throwable)e);
            if (ObjectHelper.isNotEmpty((Object)e.statusCode())) {
                builder.detail("service.status.code", (Object)e.statusCode());
            }
            if (ObjectHelper.isNotEmpty((String)e.awsErrorDetails().errorCode())) {
                builder.detail("service.error.code", (Object)e.awsErrorDetails().errorCode());
            }
            builder.down();
            return;
        }
        catch (Exception e) {
            builder.error((Throwable)e);
            builder.down();
            return;
        }
        builder.up();
    }
}

