/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.iam;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws2.iam.IAM2Configuration;
import org.apache.camel.component.aws2.iam.IAM2Endpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@org.apache.camel.spi.annotations.Component(value="aws2-iam")
public class IAM2Component
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(IAM2Component.class);
    @Metadata
    private IAM2Configuration configuration = new IAM2Configuration();

    public IAM2Component() {
        this(null);
    }

    public IAM2Component(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        IAM2Configuration configuration = this.configuration != null ? this.configuration.copy() : new IAM2Configuration();
        IAM2Endpoint endpoint = new IAM2Endpoint(uri, (Component)this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        if (!(configuration.isUseDefaultCredentialsProvider().booleanValue() || configuration.getIamClient() != null || configuration.getAccessKey() != null && configuration.getSecretKey() != null)) {
            throw new IllegalArgumentException("seDefaultCredentialsProvider is set to false, Amazon IAM client or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public IAM2Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(IAM2Configuration configuration) {
        this.configuration = configuration;
    }
}

