/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.iam.client;

import org.apache.camel.component.aws2.iam.IAM2Configuration;
import org.apache.camel.component.aws2.iam.client.IAM2InternalClient;
import org.apache.camel.component.aws2.iam.client.impl.IAM2ClientOptimizedImpl;
import org.apache.camel.component.aws2.iam.client.impl.IAM2ClientProfileOptimizedImpl;
import org.apache.camel.component.aws2.iam.client.impl.IAM2ClientSessionTokenImpl;
import org.apache.camel.component.aws2.iam.client.impl.IAM2ClientStandardImpl;

public final class IAM2ClientFactory {
    private IAM2ClientFactory() {
    }

    public static IAM2InternalClient getIamClient(IAM2Configuration configuration) {
        if (Boolean.TRUE.equals(configuration.isUseDefaultCredentialsProvider())) {
            return new IAM2ClientOptimizedImpl(configuration);
        }
        if (Boolean.TRUE.equals(configuration.isUseProfileCredentialsProvider())) {
            return new IAM2ClientProfileOptimizedImpl(configuration);
        }
        if (Boolean.TRUE.equals(configuration.isUseSessionCredentials())) {
            return new IAM2ClientSessionTokenImpl(configuration);
        }
        return new IAM2ClientStandardImpl(configuration);
    }
}

