/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.kinesis.consumer;

import org.apache.camel.component.aws2.kinesis.consumer.KinesisOffset;
import org.apache.camel.component.aws2.kinesis.consumer.KinesisResumeAdapter;
import org.apache.camel.resume.Cacheable;
import org.apache.camel.resume.Offset;
import org.apache.camel.resume.OffsetKey;
import org.apache.camel.resume.cache.ResumeCache;
import org.apache.camel.spi.annotations.JdkService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.kinesis.model.GetShardIteratorRequest;
import software.amazon.awssdk.services.kinesis.model.ShardIteratorType;

@JdkService(value="adapter-factory")
public class KinesisDefaultResumeAdapter
implements KinesisResumeAdapter,
Cacheable {
    private static final Logger LOG = LoggerFactory.getLogger(KinesisDefaultResumeAdapter.class);
    private ResumeCache<String> cache;

    public void resume() {
        throw new UnsupportedOperationException();
    }

    private void add(Object key, Object offset) {
        KinesisOffset ko = (KinesisOffset)this.cache.computeIfAbsent((Object)((String)key), k -> new KinesisOffset());
        ko.update((String)offset);
    }

    public boolean add(OffsetKey<?> key, Offset<?> offset) {
        this.add(key.getValue(), offset.getValue());
        return true;
    }

    public void setCache(ResumeCache<?> cache) {
        this.cache = cache;
    }

    public ResumeCache<?> getCache() {
        return this.cache;
    }

    @Override
    public void configureGetShardIteratorRequest(GetShardIteratorRequest.Builder builder, String streamName, String shardId) {
        KinesisOffset offset = (KinesisOffset)this.cache.get((Object)shardId, KinesisOffset.class);
        if (offset == null) {
            LOG.info("There is no offset for the stream {}", (Object)streamName);
            return;
        }
        String sequenceNumber = offset.getValue();
        LOG.info("Resuming from offset {} for key {}", (Object)sequenceNumber, (Object)streamName);
        builder.shardId(shardId);
        builder.shardIteratorType(ShardIteratorType.AFTER_SEQUENCE_NUMBER);
        builder.startingSequenceNumber(sequenceNumber);
    }
}

