/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.lambda;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.component.aws2.lambda.Lambda2Configuration;
import org.apache.camel.component.aws2.lambda.Lambda2Endpoint;
import org.apache.camel.component.aws2.lambda.Lambda2Operations;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.lambda.LambdaClient;
import software.amazon.awssdk.services.lambda.model.CreateAliasRequest;
import software.amazon.awssdk.services.lambda.model.CreateAliasResponse;
import software.amazon.awssdk.services.lambda.model.CreateEventSourceMappingRequest;
import software.amazon.awssdk.services.lambda.model.CreateEventSourceMappingResponse;
import software.amazon.awssdk.services.lambda.model.CreateFunctionRequest;
import software.amazon.awssdk.services.lambda.model.CreateFunctionResponse;
import software.amazon.awssdk.services.lambda.model.DeadLetterConfig;
import software.amazon.awssdk.services.lambda.model.DeleteAliasRequest;
import software.amazon.awssdk.services.lambda.model.DeleteAliasResponse;
import software.amazon.awssdk.services.lambda.model.DeleteEventSourceMappingRequest;
import software.amazon.awssdk.services.lambda.model.DeleteEventSourceMappingResponse;
import software.amazon.awssdk.services.lambda.model.DeleteFunctionRequest;
import software.amazon.awssdk.services.lambda.model.DeleteFunctionResponse;
import software.amazon.awssdk.services.lambda.model.Environment;
import software.amazon.awssdk.services.lambda.model.FunctionCode;
import software.amazon.awssdk.services.lambda.model.GetAliasRequest;
import software.amazon.awssdk.services.lambda.model.GetAliasResponse;
import software.amazon.awssdk.services.lambda.model.GetFunctionRequest;
import software.amazon.awssdk.services.lambda.model.GetFunctionResponse;
import software.amazon.awssdk.services.lambda.model.InvokeRequest;
import software.amazon.awssdk.services.lambda.model.InvokeResponse;
import software.amazon.awssdk.services.lambda.model.ListAliasesRequest;
import software.amazon.awssdk.services.lambda.model.ListAliasesResponse;
import software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsRequest;
import software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsResponse;
import software.amazon.awssdk.services.lambda.model.ListFunctionsRequest;
import software.amazon.awssdk.services.lambda.model.ListFunctionsResponse;
import software.amazon.awssdk.services.lambda.model.ListTagsRequest;
import software.amazon.awssdk.services.lambda.model.ListTagsResponse;
import software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionRequest;
import software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionResponse;
import software.amazon.awssdk.services.lambda.model.PublishVersionRequest;
import software.amazon.awssdk.services.lambda.model.PublishVersionResponse;
import software.amazon.awssdk.services.lambda.model.TagResourceRequest;
import software.amazon.awssdk.services.lambda.model.TagResourceResponse;
import software.amazon.awssdk.services.lambda.model.TracingConfig;
import software.amazon.awssdk.services.lambda.model.UntagResourceRequest;
import software.amazon.awssdk.services.lambda.model.UntagResourceResponse;
import software.amazon.awssdk.services.lambda.model.UpdateFunctionCodeRequest;
import software.amazon.awssdk.services.lambda.model.UpdateFunctionCodeResponse;
import software.amazon.awssdk.services.lambda.model.VpcConfig;

public class Lambda2Producer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(Lambda2Producer.class);

    public Lambda2Producer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        switch (this.determineOperation(exchange)) {
            case getFunction: {
                this.getFunction(this.getEndpoint().getAwsLambdaClient(), exchange);
                break;
            }
            case createFunction: {
                this.createFunction(this.getEndpoint().getAwsLambdaClient(), exchange);
                break;
            }
            case deleteFunction: {
                this.deleteFunction(this.getEndpoint().getAwsLambdaClient(), exchange);
                break;
            }
            case invokeFunction: {
                this.invokeFunction(this.getEndpoint().getAwsLambdaClient(), exchange);
                break;
            }
            case listFunctions: {
                this.listFunctions(this.getEndpoint().getAwsLambdaClient(), exchange);
                break;
            }
            case updateFunction: {
                this.updateFunction(this.getEndpoint().getAwsLambdaClient(), exchange);
                break;
            }
            case createEventSourceMapping: {
                this.createEventSourceMapping(this.getEndpoint().getAwsLambdaClient(), exchange);
                break;
            }
            case deleteEventSourceMapping: {
                this.deleteEventSourceMapping(this.getEndpoint().getAwsLambdaClient(), exchange);
                break;
            }
            case listEventSourceMapping: {
                this.listEventSourceMapping(this.getEndpoint().getAwsLambdaClient(), exchange);
                break;
            }
            case listTags: {
                this.listTags(this.getEndpoint().getAwsLambdaClient(), exchange);
                break;
            }
            case tagResource: {
                this.tagResource(this.getEndpoint().getAwsLambdaClient(), exchange);
                break;
            }
            case untagResource: {
                this.untagResource(this.getEndpoint().getAwsLambdaClient(), exchange);
                break;
            }
            case publishVersion: {
                this.publishVersion(this.getEndpoint().getAwsLambdaClient(), exchange);
                break;
            }
            case listVersions: {
                this.listVersions(this.getEndpoint().getAwsLambdaClient(), exchange);
                break;
            }
            case createAlias: {
                this.createAlias(this.getEndpoint().getAwsLambdaClient(), exchange);
                break;
            }
            case deleteAlias: {
                this.deleteAlias(this.getEndpoint().getAwsLambdaClient(), exchange);
                break;
            }
            case getAlias: {
                this.getAlias(this.getEndpoint().getAwsLambdaClient(), exchange);
                break;
            }
            case listAliases: {
                this.listAliases(this.getEndpoint().getAwsLambdaClient(), exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
    }

    private void getFunction(LambdaClient lambdaClient, Exchange exchange) throws InvalidPayloadException {
        GetFunctionResponse result;
        GetFunctionRequest request = null;
        if (this.getConfiguration().isPojoRequest()) {
            request = (GetFunctionRequest)exchange.getIn().getMandatoryBody(GetFunctionRequest.class);
        } else {
            GetFunctionRequest.Builder builder = GetFunctionRequest.builder();
            builder.functionName(this.getEndpoint().getFunction());
            request = (GetFunctionRequest)builder.build();
        }
        try {
            result = lambdaClient.getFunction(request);
        }
        catch (AwsServiceException ase) {
            LOG.trace("getFunction command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
        Message message = Lambda2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void deleteFunction(LambdaClient lambdaClient, Exchange exchange) throws InvalidPayloadException {
        DeleteFunctionResponse result;
        DeleteFunctionRequest request = null;
        if (this.getConfiguration().isPojoRequest()) {
            request = (DeleteFunctionRequest)exchange.getIn().getMandatoryBody(DeleteFunctionRequest.class);
        } else {
            DeleteFunctionRequest.Builder builder = DeleteFunctionRequest.builder();
            builder.functionName(this.getEndpoint().getFunction());
            request = (DeleteFunctionRequest)builder.build();
        }
        try {
            result = lambdaClient.deleteFunction(request);
        }
        catch (AwsServiceException ase) {
            LOG.trace("deleteFunction command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
        Message message = Lambda2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void listFunctions(LambdaClient lambdaClient, Exchange exchange) throws InvalidPayloadException {
        ListFunctionsResponse result;
        ListFunctionsRequest request = null;
        if (this.getConfiguration().isPojoRequest()) {
            request = (ListFunctionsRequest)exchange.getIn().getMandatoryBody(ListFunctionsRequest.class);
        } else {
            ListFunctionsRequest.Builder builder = ListFunctionsRequest.builder();
            request = (ListFunctionsRequest)builder.build();
        }
        try {
            result = lambdaClient.listFunctions(request);
        }
        catch (AwsServiceException ase) {
            LOG.trace("listFunctions command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
        Message message = Lambda2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void invokeFunction(LambdaClient lambdaClient, Exchange exchange) throws InvalidPayloadException {
        InvokeResponse result;
        InvokeRequest request = null;
        if (this.getConfiguration().isPojoRequest()) {
            request = (InvokeRequest)exchange.getIn().getMandatoryBody(InvokeRequest.class);
        } else {
            InvokeRequest.Builder builder = InvokeRequest.builder();
            request = (InvokeRequest)builder.functionName(this.getEndpoint().getFunction()).payload(SdkBytes.fromString((String)((String)exchange.getIn().getBody(String.class)), (Charset)Charset.defaultCharset())).build();
        }
        try {
            result = lambdaClient.invoke(request);
        }
        catch (AwsServiceException ase) {
            LOG.trace("invokeFunction command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
        Message message = Lambda2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result.payload().asUtf8String());
    }

    private void createFunction(LambdaClient lambdaClient, Exchange exchange) throws Exception {
        CreateFunctionResponse result;
        CreateFunctionRequest request = null;
        if (this.getConfiguration().isPojoRequest()) {
            request = (CreateFunctionRequest)exchange.getIn().getMandatoryBody(CreateFunctionRequest.class);
        } else {
            Map tags;
            Map environmentVariables;
            CreateFunctionRequest.Builder builder = CreateFunctionRequest.builder();
            builder.functionName(this.getEndpoint().getFunction());
            FunctionCode.Builder functionCode = FunctionCode.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaS3Bucket"))) {
                String s3Bucket = (String)exchange.getIn().getHeader("CamelAwsLambdaS3Bucket", String.class);
                functionCode.s3Bucket(s3Bucket);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaS3Key"))) {
                String s3Key = (String)exchange.getIn().getHeader("CamelAwsLambdaS3Key", String.class);
                functionCode.s3Key(s3Key);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaS3ObjectVersion"))) {
                String s3ObjectVersion = (String)exchange.getIn().getHeader("CamelAwsLambdaS3ObjectVersion", String.class);
                functionCode.s3ObjectVersion(s3ObjectVersion);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaZipFile"))) {
                String zipFile = (String)exchange.getIn().getHeader("CamelAwsLambdaZipFile", String.class);
                File fileLocalPath = new File(zipFile);
                try (FileInputStream inputStream = new FileInputStream(fileLocalPath);){
                    functionCode.zipFile(SdkBytes.fromInputStream((InputStream)inputStream));
                }
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getBody())) {
                functionCode.zipFile(SdkBytes.fromByteBuffer((ByteBuffer)((ByteBuffer)exchange.getIn().getBody(ByteBuffer.class))));
            }
            if (!(ObjectHelper.isNotEmpty((Object)exchange.getIn().getBody()) || ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaZipFile")) || ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaS3Bucket")) && ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaS3Key")))) {
                throw new IllegalArgumentException("At least S3 bucket/S3 key or zip file must be specified");
            }
            builder.code((FunctionCode)functionCode.build());
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaRole"))) {
                throw new IllegalArgumentException("Role must be specified");
            }
            builder.role((String)exchange.getIn().getHeader("CamelAwsLambdaRole", String.class));
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaRuntime"))) {
                throw new IllegalArgumentException("Runtime must be specified");
            }
            builder.runtime((String)exchange.getIn().getHeader("CamelAwsLambdaRuntime", String.class));
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaHandler"))) {
                throw new IllegalArgumentException("Handler must be specified");
            }
            builder.handler((String)exchange.getIn().getHeader("CamelAwsLambdaHandler", String.class));
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaDescription"))) {
                String description = (String)exchange.getIn().getHeader("CamelAwsLambdaDescription", String.class);
                builder.description(description);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaTargetArn"))) {
                String targetArn = (String)exchange.getIn().getHeader("CamelAwsLambdaTargetArn", String.class);
                builder.deadLetterConfig((DeadLetterConfig)DeadLetterConfig.builder().targetArn(targetArn).build());
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaMemorySize"))) {
                Integer memorySize = (Integer)exchange.getIn().getHeader("CamelAwsLambdaMemorySize", Integer.class);
                builder.memorySize(memorySize);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaKMSKeyArn"))) {
                String kmsKeyARN = (String)exchange.getIn().getHeader("CamelAwsLambdaKMSKeyArn", String.class);
                builder.kmsKeyArn(kmsKeyARN);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaPublish"))) {
                Boolean publish = (Boolean)exchange.getIn().getHeader("CamelAwsLambdaPublish", Boolean.class);
                builder.publish(publish);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaTimeout"))) {
                Integer timeout = (Integer)exchange.getIn().getHeader("CamelAwsLambdaTimeout", Integer.class);
                builder.timeout(timeout);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaTracingConfig"))) {
                String tracingConfigMode = (String)exchange.getIn().getHeader("CamelAwsLambdaTracingConfig", String.class);
                builder.tracingConfig((TracingConfig)TracingConfig.builder().mode(tracingConfigMode).build());
            }
            if ((environmentVariables = CastUtils.cast((Map)((Map)exchange.getIn().getHeader("CamelAwsLambdaEnvironmentVariables", Map.class)))) != null) {
                builder.environment((Environment)Environment.builder().variables(environmentVariables).build());
            }
            if ((tags = CastUtils.cast((Map)((Map)exchange.getIn().getHeader("CamelAwsLambdaTags", Map.class)))) != null) {
                builder.tags(tags);
            }
            List securityGroupIds = CastUtils.cast((List)((List)exchange.getIn().getHeader("CamelAwsLambdaSecurityGroupIds", List.class)));
            List subnetIds = CastUtils.cast((List)((List)exchange.getIn().getHeader("CamelAwsLambdaSubnetIds", List.class)));
            if (securityGroupIds != null || subnetIds != null) {
                VpcConfig.Builder vpcConfig = VpcConfig.builder();
                if (securityGroupIds != null) {
                    vpcConfig.securityGroupIds((Collection)securityGroupIds);
                }
                if (subnetIds != null) {
                    vpcConfig.subnetIds((Collection)subnetIds);
                }
                builder.vpcConfig((VpcConfig)vpcConfig.build());
            }
            request = (CreateFunctionRequest)builder.build();
        }
        try {
            result = lambdaClient.createFunction(request);
        }
        catch (AwsServiceException ase) {
            LOG.trace("createFunction command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
        Message message = Lambda2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void updateFunction(LambdaClient lambdaClient, Exchange exchange) throws Exception {
        UpdateFunctionCodeResponse result;
        UpdateFunctionCodeRequest request = null;
        if (this.getConfiguration().isPojoRequest()) {
            request = (UpdateFunctionCodeRequest)exchange.getIn().getMandatoryBody(UpdateFunctionCodeRequest.class);
        } else {
            UpdateFunctionCodeRequest.Builder builder = UpdateFunctionCodeRequest.builder();
            builder.functionName(this.getEndpoint().getFunction());
            if (ObjectHelper.isEmpty((Object)exchange.getIn().getBody()) && ObjectHelper.isEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaS3Bucket")) && ObjectHelper.isEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaS3Key"))) {
                throw new IllegalArgumentException("At least S3 bucket/S3 key or zip file must be specified");
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaPublish"))) {
                Boolean publish = (Boolean)exchange.getIn().getHeader("CamelAwsLambdaPublish", Boolean.class);
                builder.publish(publish);
            }
            request = (UpdateFunctionCodeRequest)builder.build();
        }
        try {
            result = lambdaClient.updateFunctionCode(request);
        }
        catch (AwsServiceException ase) {
            LOG.trace("updateFunction command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
        Message message = Lambda2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void createEventSourceMapping(LambdaClient lambdaClient, Exchange exchange) throws InvalidPayloadException {
        CreateEventSourceMappingResponse result;
        CreateEventSourceMappingRequest request = null;
        if (this.getConfiguration().isPojoRequest()) {
            request = (CreateEventSourceMappingRequest)exchange.getIn().getMandatoryBody(CreateEventSourceMappingRequest.class);
        } else {
            CreateEventSourceMappingRequest.Builder builder = CreateEventSourceMappingRequest.builder();
            builder.functionName(this.getEndpoint().getFunction());
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaEventSourceArn"))) {
                throw new IllegalArgumentException("Event Source Arn must be specified");
            }
            builder.eventSourceArn((String)exchange.getIn().getHeader("CamelAwsLambdaEventSourceArn", String.class));
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaEventSourceBatchSize"))) {
                Integer batchSize = (Integer)exchange.getIn().getHeader("CamelAwsLambdaEventSourceBatchSize", Integer.class);
                builder.batchSize(batchSize);
            }
            request = (CreateEventSourceMappingRequest)builder.build();
        }
        try {
            result = lambdaClient.createEventSourceMapping(request);
        }
        catch (AwsServiceException ase) {
            LOG.trace("createEventSourceMapping command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
        Message message = Lambda2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void deleteEventSourceMapping(LambdaClient lambdaClient, Exchange exchange) throws InvalidPayloadException {
        DeleteEventSourceMappingResponse result;
        DeleteEventSourceMappingRequest request = null;
        if (this.getConfiguration().isPojoRequest()) {
            request = (DeleteEventSourceMappingRequest)exchange.getIn().getMandatoryBody(DeleteEventSourceMappingRequest.class);
        } else {
            DeleteEventSourceMappingRequest.Builder builder = DeleteEventSourceMappingRequest.builder();
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaEventSourceUuid"))) {
                throw new IllegalArgumentException("Event Source Arn must be specified");
            }
            builder.uuid((String)exchange.getIn().getHeader("CamelAwsLambdaEventSourceUuid", String.class));
            request = (DeleteEventSourceMappingRequest)builder.build();
        }
        try {
            result = lambdaClient.deleteEventSourceMapping(request);
        }
        catch (AwsServiceException ase) {
            LOG.trace("deleteEventSourceMapping command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
        Message message = Lambda2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void listEventSourceMapping(LambdaClient lambdaClient, Exchange exchange) throws InvalidPayloadException {
        ListEventSourceMappingsResponse result;
        ListEventSourceMappingsRequest request = null;
        if (this.getConfiguration().isPojoRequest()) {
            request = (ListEventSourceMappingsRequest)exchange.getIn().getMandatoryBody(ListEventSourceMappingsRequest.class);
        } else {
            ListEventSourceMappingsRequest.Builder builder = ListEventSourceMappingsRequest.builder();
            builder.functionName(this.getEndpoint().getFunction());
            request = (ListEventSourceMappingsRequest)builder.build();
        }
        try {
            result = lambdaClient.listEventSourceMappings(request);
        }
        catch (AwsServiceException ase) {
            LOG.trace("listEventSourceMapping command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
        Message message = Lambda2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void listTags(LambdaClient lambdaClient, Exchange exchange) throws InvalidPayloadException {
        ListTagsResponse result;
        ListTagsRequest request = null;
        if (this.getConfiguration().isPojoRequest()) {
            request = (ListTagsRequest)exchange.getIn().getMandatoryBody(ListTagsRequest.class);
        } else {
            ListTagsRequest.Builder builder = ListTagsRequest.builder();
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaResourceArn"))) {
                throw new IllegalArgumentException("The resource ARN must be specified");
            }
            String resource = (String)exchange.getIn().getHeader("CamelAwsLambdaResourceArn", String.class);
            builder.resource(resource);
            request = (ListTagsRequest)builder.build();
        }
        try {
            result = lambdaClient.listTags(request);
        }
        catch (AwsServiceException ase) {
            LOG.trace("listTags command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
        Message message = Lambda2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void tagResource(LambdaClient lambdaClient, Exchange exchange) throws InvalidPayloadException {
        TagResourceResponse result;
        TagResourceRequest request = null;
        if (this.getConfiguration().isPojoRequest()) {
            request = (TagResourceRequest)exchange.getIn().getMandatoryBody(TagResourceRequest.class);
        } else {
            TagResourceRequest.Builder builder = TagResourceRequest.builder();
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaResourceArn"))) {
                throw new IllegalArgumentException("The resource ARN must be specified");
            }
            String resource = (String)exchange.getIn().getHeader("CamelAwsLambdaResourceArn", String.class);
            builder.resource(resource);
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaResourceTags"))) {
                throw new IllegalArgumentException("The tags must be specified");
            }
            Map tags = (Map)exchange.getIn().getHeader("CamelAwsLambdaResourceTags", Map.class);
            builder.tags(tags);
            request = (TagResourceRequest)builder.build();
        }
        try {
            result = lambdaClient.tagResource(request);
        }
        catch (AwsServiceException ase) {
            LOG.trace("listTags command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
        Message message = Lambda2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void untagResource(LambdaClient lambdaClient, Exchange exchange) throws InvalidPayloadException {
        UntagResourceResponse result;
        UntagResourceRequest request = null;
        if (this.getConfiguration().isPojoRequest()) {
            request = (UntagResourceRequest)exchange.getIn().getMandatoryBody(UntagResourceRequest.class);
        } else {
            UntagResourceRequest.Builder builder = UntagResourceRequest.builder();
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaResourceArn"))) {
                throw new IllegalArgumentException("The resource ARN must be specified");
            }
            String resource = (String)exchange.getIn().getHeader("CamelAwsLambdaResourceArn", String.class);
            builder.resource(resource);
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaResourceTagKeys"))) {
                throw new IllegalArgumentException("The tag keys must be specified");
            }
            List tagKeys = (List)exchange.getIn().getHeader("CamelAwsLambdaResourceTagKeys", List.class);
            builder.tagKeys((Collection)tagKeys);
            request = (UntagResourceRequest)builder.build();
        }
        try {
            result = lambdaClient.untagResource(request);
        }
        catch (AwsServiceException ase) {
            LOG.trace("untagResource command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
        Message message = Lambda2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void publishVersion(LambdaClient lambdaClient, Exchange exchange) throws InvalidPayloadException {
        PublishVersionResponse result;
        PublishVersionRequest request = null;
        if (this.getConfiguration().isPojoRequest()) {
            request = (PublishVersionRequest)exchange.getIn().getMandatoryBody(PublishVersionRequest.class);
        } else {
            PublishVersionRequest.Builder builder = PublishVersionRequest.builder();
            builder.functionName(this.getEndpoint().getFunction());
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaVersionDescription"))) {
                String description = (String)exchange.getIn().getHeader("CamelAwsLambdaVersionDescription", String.class);
                builder.description(description);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaVersionRevisionId"))) {
                String revisionId = (String)exchange.getIn().getHeader("CamelAwsLambdaVersionRevisionId", String.class);
                builder.revisionId(revisionId);
            }
            request = (PublishVersionRequest)builder.build();
        }
        try {
            result = lambdaClient.publishVersion(request);
        }
        catch (AwsServiceException ase) {
            LOG.trace("publishVersion command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
        Message message = Lambda2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void listVersions(LambdaClient lambdaClient, Exchange exchange) throws InvalidPayloadException {
        ListVersionsByFunctionResponse result;
        ListVersionsByFunctionRequest request = null;
        if (this.getConfiguration().isPojoRequest()) {
            request = (ListVersionsByFunctionRequest)exchange.getIn().getMandatoryBody(ListVersionsByFunctionRequest.class);
        } else {
            ListVersionsByFunctionRequest.Builder builder = ListVersionsByFunctionRequest.builder();
            builder.functionName(this.getEndpoint().getFunction());
            request = (ListVersionsByFunctionRequest)builder.build();
        }
        try {
            result = lambdaClient.listVersionsByFunction(request);
        }
        catch (AwsServiceException ase) {
            LOG.trace("publishVersion command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
        Message message = Lambda2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void createAlias(LambdaClient lambdaClient, Exchange exchange) throws InvalidPayloadException {
        CreateAliasResponse result;
        CreateAliasRequest request = null;
        if (this.getConfiguration().isPojoRequest()) {
            request = (CreateAliasRequest)exchange.getIn().getMandatoryBody(CreateAliasRequest.class);
        } else {
            CreateAliasRequest.Builder builder = CreateAliasRequest.builder();
            builder.functionName(this.getEndpoint().getFunction());
            String version = (String)exchange.getIn().getHeader("CamelAwsLambdaFunctionVersion", String.class);
            String aliasName = (String)exchange.getIn().getHeader("CamelAwsLambdaAliasFunctionName", String.class);
            if (ObjectHelper.isEmpty((String)version) || ObjectHelper.isEmpty((String)aliasName)) {
                throw new IllegalArgumentException("Function Version and alias must be specified to create an alias");
            }
            builder.functionVersion(version);
            builder.name(aliasName);
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsLambdaAliasFunctionDescription"))) {
                String aliasDescription = (String)exchange.getIn().getHeader("CamelAwsLambdaAliasFunctionDescription", String.class);
                builder.description(aliasDescription);
            }
            request = (CreateAliasRequest)builder.build();
        }
        try {
            result = lambdaClient.createAlias(request);
        }
        catch (AwsServiceException ase) {
            LOG.trace("createAlias command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
        Message message = Lambda2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void deleteAlias(LambdaClient lambdaClient, Exchange exchange) throws InvalidPayloadException {
        DeleteAliasResponse result;
        DeleteAliasRequest request = null;
        if (this.getConfiguration().isPojoRequest()) {
            request = (DeleteAliasRequest)exchange.getIn().getMandatoryBody(DeleteAliasRequest.class);
        } else {
            DeleteAliasRequest.Builder builder = DeleteAliasRequest.builder();
            builder.functionName(this.getEndpoint().getFunction());
            String aliasName = (String)exchange.getIn().getHeader("CamelAwsLambdaAliasFunctionName", String.class);
            if (ObjectHelper.isEmpty((String)aliasName)) {
                throw new IllegalArgumentException("Function alias must be specified to delete an alias");
            }
            builder.name(aliasName);
            request = (DeleteAliasRequest)builder.build();
        }
        try {
            result = lambdaClient.deleteAlias(request);
        }
        catch (AwsServiceException ase) {
            LOG.trace("deleteAlias command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
        Message message = Lambda2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void getAlias(LambdaClient lambdaClient, Exchange exchange) throws InvalidPayloadException {
        GetAliasResponse result;
        GetAliasRequest request = null;
        if (this.getConfiguration().isPojoRequest()) {
            request = (GetAliasRequest)exchange.getIn().getMandatoryBody(GetAliasRequest.class);
        } else {
            GetAliasRequest.Builder builder = GetAliasRequest.builder();
            builder.functionName(this.getEndpoint().getFunction());
            String aliasName = (String)exchange.getIn().getHeader("CamelAwsLambdaAliasFunctionName", String.class);
            if (ObjectHelper.isEmpty((String)aliasName)) {
                throw new IllegalArgumentException("Function alias must be specified to get an alias");
            }
            builder.name(aliasName);
            request = (GetAliasRequest)builder.build();
        }
        try {
            result = lambdaClient.getAlias(request);
        }
        catch (AwsServiceException ase) {
            LOG.trace("getAlias command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
        Message message = Lambda2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void listAliases(LambdaClient lambdaClient, Exchange exchange) throws InvalidPayloadException {
        ListAliasesResponse result;
        ListAliasesRequest request = null;
        if (this.getConfiguration().isPojoRequest()) {
            request = (ListAliasesRequest)exchange.getIn().getMandatoryBody(ListAliasesRequest.class);
        } else {
            ListAliasesRequest.Builder builder = ListAliasesRequest.builder();
            builder.functionName(this.getEndpoint().getFunction());
            String version = (String)exchange.getIn().getHeader("CamelAwsLambdaFunctionVersion", String.class);
            if (!ObjectHelper.isEmpty((String)version)) {
                builder.functionVersion(version);
            }
            request = (ListAliasesRequest)builder.build();
        }
        try {
            result = lambdaClient.listAliases(request);
        }
        catch (AwsServiceException ase) {
            LOG.trace("listAliases command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
        Message message = Lambda2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private Lambda2Operations determineOperation(Exchange exchange) {
        Lambda2Operations operation = (Lambda2Operations)((Object)exchange.getIn().getHeader("CamelAwsLambdaOperation", Lambda2Operations.class));
        if (operation == null) {
            operation = this.getConfiguration().getOperation() == null ? Lambda2Operations.invokeFunction : this.getConfiguration().getOperation();
        }
        return operation;
    }

    protected Lambda2Configuration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public Lambda2Endpoint getEndpoint() {
        return (Lambda2Endpoint)super.getEndpoint();
    }

    public static Message getMessageForResponse(Exchange exchange) {
        return exchange.getMessage();
    }
}

